<?php

/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('ucla-prose entry-content has-global-padding is-layout-constrained'); ?>>
  <?php
    if (!is_home()) {
      the_title('<h1 class="visuallyhidden">', '</h1>');
    }
  ?>
  <?php if (has_post_thumbnail()) : ?>
      <figure class="post-thumbnail featured-image alignfull">
        <?php
        // Lazy-loading attributes should be skipped for thumbnails since they are immediately in the viewport.
        the_post_thumbnail('post-thumbnail', array('loading' => false, 'class' => 'ucla-img-responsive'));
        ?>
        <?php if (wp_get_attachment_caption(get_post_thumbnail_id())) : ?>
          <figcaption class="wp-caption-text"><?php echo wp_kses_post(wp_get_attachment_caption(get_post_thumbnail_id())); ?></figcaption>
        <?php endif; ?>

      </figure><!-- .post-thumbnail -->
    <?php endif;
    the_content();
    ?>
</article>