<?php
  $custom_logo_id = get_theme_mod('custom_logo');
  $custom_mobile_logo = get_theme_mod('ucla_mobile_logo');
  $logo = wp_get_attachment_image_src( $custom_logo_id , 'full' );
?>
<header class="ucla-header ucla-header--school">
  <div class="ucla-header__container" id="header-wrap">
      <a class="ucla-header--school__logo-link" href="<?php echo esc_url(home_url('/')); ?>">
    <?php
      if ($custom_logo_id) :
        $logo_alt_text = esc_html(get_bloginfo('name')) . ' Logo';
    ?>
        <img class="ucla-header--school__custom-logo<?=$custom_mobile_logo ? ' ucla-header--has-mobile-logo' : '';?>" src="<?php echo $logo[0] ?>" alt="<?=$logo_alt_text;?>" />
        <?php
          if ($custom_mobile_logo) :
        ?>
        <img class="ucla-header--mobile-logo" src="<?=$custom_mobile_logo;?>" />
        <?php
          endif;
        else :
        ?>
        <svg xmlns="http://www.w3.org/2000/svg" id="ucla-box-black" viewBox="0 0 360 168.84" role="img">
          <title>UCLA Logo</title>
          <defs></defs>
          <rect class="cls-1" width="360" height="168.84" fill="#2774ae" />
          <path fill="#ffffff" d="M57.57,100.65a72.15,72.15,0,0,1-.18-8.51l4.06-46H76.52L72.39,92.54c-.89,10,3,17.22,13.08,17.22,10.26,0,15.68-7.29,16.57-16.21l4.28-47.44h15.06L117.21,93c-1.68,18-13.64,31.54-33,31.54-15.08,0-24.8-9.75-26.65-23.85" />
          <path fill="#ffffff" d="M124.84,85.07c2-22.1,16.87-40.42,42.62-40.42a35.32,35.32,0,0,1,19.79,5.73l-1.72,18.25c-5.94-7.81-13-9.08-19.51-9.08-16,0-24.81,11.13-26.07,25.22-1.21,13.71,5.87,24.87,21.39,24.87,6.78,0,14-2,21.48-9.47l-1.66,18.73c-7.33,4-14.14,5.78-21,5.78-25.48,0-37.15-18.93-35.32-39.61" />
          <path fill="#ffffff" d="M199.28,46.11h15l-5.48,62.5h21.53c1.52,0,6.65-.08,8-.16-.08.75-1.37,14.44-1.37,14.44H192.46Z" />
          <path fill="#ffffff" d="M277.57,74.77a18,18,0,0,0,1.11-3.22h.24a18.25,18.25,0,0,0,.57,3.25c.83,3.5,6.68,22.94,6.68,22.94h-19s10.17-22.46,10.37-23m3.85-32.18-1,0-41.15,80.28h16L261,110.71h29l3.62,12.18h15.93Z" />
        </svg>
        <?php echo esc_html(get_bloginfo('name')); ?>
    <?php endif; ?>
      </a>
    <?php if (has_nav_menu('secondary-menu')) { ?>
      <?php
      wp_nav_menu(array(
        'theme_location' => 'secondary-menu',
        'container' => 'nav',
        'container_class' => 'ucla-secondary-nav',
        'container_id' => 'nav-second',
        'container_aria_label' => 'Secondary Menu',
        'depth' => 0,
        'menu_class' => 'ucla-secondary-nav__list',
        'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
        'walker' => new Ucla_Wordpress_Secondary_Navigation_Walker()
      ));
      ?>
    <?php } ?>
    <button id="primary-ham" class="hamburger" type="button" aria-controls="nav-main" aria-expanded="false" alt="navigation and search">
      <span class="hamburger__box">
        <span class="hamburger__inner"></span>
      </span>
    </button>
    <nav aria-labelledby="primary-ham" id="nav-main" class="ucla-main-nav" aria-label="Main Menu">
      <?php if (has_nav_menu('main-menu')) { ?>
        <ul class="ucla-main-nav__list" role="menubar" data-menubar-item-expanded="true">
          <?php
          wp_nav_menu(array(
            'theme_location' => 'main-menu',
            'container' => false,
            'depth' => 4,
            'items_wrap' => '%3$s',
            'walker' => new Ucla_Wordpress_Primary_Navigation_Walker()
          ));
          ?>
        </ul>
        <?php if (has_nav_menu('secondary-menu')) {
          wp_nav_menu(array(
            'theme_location' => 'secondary-menu',
            'container' => false,
            'depth' => 1,
            'menu_class' => 'ucla-secondary-nav__list',
            'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
            'walker' => new Ucla_Wordpress_Secondary_Navigation_Walker()
          ));
        } ?>

      <?php } ?>
      <div class="ucla-main-nav__search-desktop" id="primary-nav-search">
        <button id="search-button" aria-expanded="false" class="ucla-main-nav__search-desktop-button">
          <svg role="img" aria-label="Search Icon" class="ucla-main-nav__search-icon" width="18px" height="18px" viewBox="0 0 18 18" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <title>Search Icon</title>
            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
              <g transform="translate(-15.000000, -15.000000)">
                <g id="Nav-Item">
                  <g transform="translate(12.000000, 12.000000)">
                    <polygon class="Path-polygon" points="0 0 24 0 24 24 0 24"></polygon>
                    <path d="M15.5,14 L14.71,14 L14.43,13.73 C15.41,12.59 16,11.11 16,9.5 C16,5.91 13.09,3 9.5,3 C5.91,3 3,5.91 3,9.5 C3,13.09 5.91,16 9.5,16 C11.11,16 12.59,15.41 13.73,14.43 L14,14.71 L14,15.5 L19,20.49 L20.49,19 L15.5,14 Z M9.5,14 C7.01,14 5,11.99 5,9.5 C5,7.01 7.01,5 9.5,5 C11.99,5 14,7.01 14,9.5 C14,11.99 11.99,14 9.5,14 Z" fill="#00598C" fill-rule="evenodd"></path>
                  </g>
                </g>
              </g>
            </g>
          </svg>
          <svg class="ucla-main-nav__search-close" xmlns="http://www.w3.org/2000/svg" width="18px" height="18px" xml:space="preserve" viewBox="10 10 28 28">
            <title>Close</title>
            <path d="M38 12.8 35.2 10 24 21.2 12.8 10 10 12.8 21.2 24 10 35.2l2.8 2.8L24 26.8 35.2 38l2.8-2.8L26.8 24 38 12.8z" fill="#ffffff" fill-rule="evenodd"></path>
          </svg>
        </button>
        <div class="ucla-main-nav__search-block-form" id="block-search" role="search">
          <?php get_search_form() ?>
        </div>
      </div>
    </nav>
  </div>
</header>