
<?php if (!is_front_page()) : ?>
  <header class="ucla-content-header">
    <?php get_breadcrumbs() ?>
    <?php the_title('<h1 class="headline-text__xl">', '</h1>'); ?>
  </header><!-- .entry-header -->
<?php endif; ?>
<article id="post-<?php the_ID(); ?>" <?php post_class('ucla-content'); ?>>
  <?php if (has_post_thumbnail()) : ?>
    <figure class="post-thumbnail featured-image">
      <?php
      // Lazy-loading attributes should be skipped for thumbnails since they are immediately in the viewport.
      the_post_thumbnail('post-thumbnail', array('loading' => false, 'class' => 'ucla-img-responsive'));
      ?>
      <?php if (wp_get_attachment_caption(get_post_thumbnail_id())) : ?>
        <figcaption class="wp-caption-text"><?php echo wp_kses_post(wp_get_attachment_caption(get_post_thumbnail_id())); ?></figcaption>
      <?php endif; ?>
    </figure><!-- .post-thumbnail -->
  <?php endif;
  if (is_single()) :
  ?>
<div class="ucla-wordpress__post-detail mb-6">
      <?php
        printf(
          /* translators: %s: Author name. */
          __('<p class="ucla-wordpress__post-author mb-0">By %s</p>', 'ucla-wordpress'),
          esc_html(get_the_author())
        );
        echo sprintf(
          '<time datetime="%2$s" class="ucla-wordpress__post-date">%1$s</time>',
          esc_html(get_the_date('F j, Y')),
          esc_html(get_the_date('Y-m-d'))
        );
      ?>
      </div>
    <?php endif; ?>
  <div class="ucla-prose">
    <?php the_content() ?>
  </div>
  <?php
    if (is_single()) {
      $posttags = get_the_tags();
      if ($posttags) {
  ?>
  <footer class="ucla-wordpress__post-tags mt-9">
    <p class="mb-0">Tags:</p>
    <ul class="ucla-wordpress__post-tags-list">
      <?php foreach ($posttags as $tag) { ?>
        <li><a href="<?= esc_attr(get_tag_link($tag->term_id)) ?>"><?= $tag->name ?></a></li>
      <?php  } ?>
    </ul>
  </footer>
  <?php 
      } 
     }
    ?>
</article>
<?php get_sidebar(); ?>