<?php

/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 */

?>
<section class="no-results not-found">
  <?php if (is_home() && current_user_can('publish_posts')) : ?>

    <?php
    printf(
      '<p>' . wp_kses(
        /* translators: %s: Link to WP admin new post page. */
        __('Ready to publish your first post? <a href="%s">Get started here</a>.', 'ucla-wordpress'),
        array(
          'a' => array(
            'href' => array(),
          ),
        )
      ) . '</p>',
      esc_url(admin_url('post-new.php'))
    );
    ?>

  <?php elseif (is_search()) : ?>
    <div class="col span_12_of_12 span_8_of_12-md">
      <p class="lead"><?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'ucla-wordpress'); ?></p>
    </div>

  <?php else : ?>

    <p><?php esc_html_e('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'ucla-wordpress'); ?></p>
    <form role="search" method="get" class="ucla-search__form mt-6" action="<?= home_url('/') ?>" id="menu-search-desktop">
      <label>
        <span class="visuallyhidden">Search for:</span>
        <input type="search" class="ucla-search__field" placeholder="Search …" value="<?php echo esc_html(get_search_query()) ?>" name="s">
      </label>
      <input type="submit" class="ucla-btn ucla-btn--primary" value="Search">
    </form>

  <?php endif; ?>
</section>