<?php

/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package WordPress
 */

get_header(); ?>
<main class="container" id="main">
  <div class="ucla">
    <div class="col span_10_of_12-lg span_12_of_12">
      <header>
        <?php get_breadcrumbs() ?>
        <h1 class="headline-text__xl">
          <?php
          printf(
            /* translators: %s: Search term. */
            esc_html__('Search', 'ucla-wordpress'),
            '<span class="page-description search-term">' . esc_html(get_search_query()) . '</span>'
          );

          ?>
        </h1>
        <form role="search" method="get" class="ucla-search__form" action="<?= home_url('/') ?>" id="menu-search-desktop">
          <label>
            <span class="visuallyhidden">Search for:</span>
            <input type="search" class="ucla-search__field" placeholder="Search …" value="<?php echo esc_html(get_search_query()) ?>" name="s">
          </label>
          <input type="submit" class="ucla-btn ucla-btn--primary" value="Search">
        </form>
      </header><!-- .page-header -->

    </div>
  </div>

  <div class="ucla-grid cols-1 cols-3-md">
    <?php if (have_posts()) {
      // Start the Loop.
      while (have_posts()) {
        the_post();
        get_template_part('template-parts/content/content-excerpt');
      }
    } else {
      get_template_part('template-parts/content/content-none');
    } ?>
  </div>
</main>
<?php get_footer();
