<?php
// Add aria-hidden to Video tag in Cover Block
function add_aria_hidden_to_cover_block_video( $block_content, $block ) {
  $p = new WP_HTML_Tag_Processor($block_content);
  if ($p->next_tag('video')) {
    $p->set_attribute('aria-hidden', 'true');
  }
  $block_content = $p->get_updated_html();

  // Checks if Cover Block is Video and adds button for control
  $block_content = preg_replace('/(<video[^>]*><\/video>)(<span[^>]*><\/span>)/i', '$1<button class="ucla__cover_button-control playing"><svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="none"><g filter="url(#a)"><circle cx="19.999" cy="19.999" r="19.999" fill="#000" fill-opacity=".65"/></g><path fill="#fff" d="M13 29h5V11h-5v18ZM22 29h5V11h-5v18Z"/><defs><filter id="a" width="47.999" height="47.999" x="-4" y="-4" color-interpolation-filters="sRGB" filterUnits="userSpaceOnUse"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feGaussianBlur in="BackgroundImageFix" stdDeviation="2"/><feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_0_1"/><feBlend in="SourceGraphic" in2="effect1_backgroundBlur_0_1" result="shape"/></filter></defs></svg></button>$2', $block_content);
  
  return $block_content;
}
add_filter('render_block_core/cover', 'add_aria_hidden_to_cover_block_video', 10, 2);

function enqueue_video_control_script_if_cover_block($content="") {
  if (has_block('core/cover')) {
    wp_register_script(
      'ucla_cover_block_script',
      get_template_directory_uri() . '/assets/js/cover-block-video-control.js',
      array(),
      null,
      true
    );
    wp_enqueue_script('ucla_cover_block_script');
  }
}
add_action( 'enqueue_block_assets', 'enqueue_video_control_script_if_cover_block' );