<?php

/***
 * Check if post is in menu
 * @param $menu menu name, id, or slug
 * @param $object_id int, post, object, or id of page,
 * @return boolean true if object is in menu
 */
function post_in_side_navigation($menu = null, $object_id = null)
{
  // get menu object
  $menu_object = wp_get_nav_menu_items(esc_attr($menu));

  // stop if there isn't a menu
  if (!$menu_object) {
    return false;
  }

  // get the object_id field out of the menu object
  $menu_items = wp_list_pluck($menu_object, 'object_id');

  // use the current post if object_id is not specified
  if (!$object_id) {
    global $post;
    $object_id = get_queried_object_id();
  }

  foreach ($menu_object as $item) {
    if ($object_id == $item->object_id) {
      if ($item->menu_item_parent == "0") {
        return false;
      }
    }
  }
  // test if the specified page is in the menu or not. return true or false.
  return in_array((int) $object_id, $menu_items);
}
