<?php
if (! defined('ABSPATH')) {
  exit; // disable direct access.
}
function ucla_mega_menu_cpt() {
register_post_type(
  'ucla-mega-menu',
  array(
    'labels' => array(
      'name' => __('Mega Menus', 'ucla-wordpress'),
      'singular_name' => __('Mega Menu', 'ucla-wordpress'),
      'add_new' => __('Add New Mega Menu', 'ucla-wordpress'),
      'add_new_item' => __('Add New Mega Menu', 'ucla-wordpress'),
      'edit' => __('Edit', 'ucla-wordpress'),
      'edit_item' => __('Edit Mega Menu', 'ucla-wordpress'),
      'new_item' => __('New Mega Menu', 'ucla-wordpress'),
      'view' => __('View Mega Menus', 'ucla-wordpress'),
      'view_item' => __('View Mega Menu', 'ucla-wordpress'),
      'view_items' => __('View Mega Menus', 'ucla-wordpress'),
      'search_items' => __('Search Mega Menus', 'ucla-wordpress'),
      'not_found' => __('No Mega Menus found', 'ucla-wordpress'),
      'not_found_in_trash' => __('No Mega Menus found in Trash', 'ucla-wordpress'),
      'featured_image' => __('Profile Image', 'ucla-wordpress'),
      'set_featured_image' => __('Set Profile Image', 'ucla-wordpress'),
      'remove_featured_image' => __('Remove Profile Image', 'ucla-wordpress'),
      'use_featured_image' => __('Use as Profile Image', 'ucla-wordpress'),
      'archives' => __('Mega Menus Archives', 'ucla-wordpress'),
      'attributes' => __('Mega Menus Attributes', 'ucla-wordpress'),
      'item_published' => __('Mega Menu published.', 'ucla-wordpress'),
    ),
    'description' => 'Mega Menu Description',
    'public'  => true,
    'show_in_rest' => true,
    'show_in_menu' => 'ucla_mega_menu_location',
    'hierarchical' => false,
    'has_archive' => false,
    'can_export' => true,
    'exclude_from_search' => true,
    'rewrite' => array('slug' => 'mega-menu', 'with_front' => false),
    'supports' => array(
      'title',
      'editor',
      'custom-fields'
    ),
    'publicly_queryable'  => false,
    'template' => array(
      array(
        'core/columns',
        array(
          'align' => 'wide'
        ),
        array(
          array(
            'core/column',
            array(),
            array(
              array(
                'core/heading',
                array(
                  'placeholder' => 'Menu Heading',
                  'textColor' => 'gray-60',
                  'fontSize' => 'small',
                )
              ),
              array(
                'core/list',
                array(
                  'className' => 'is-style-unstyled'
                ),
                array(
                  array(
                    'core/list-item',
                    array(
                      'content' => '<a href="#"><strong>Link</strong></a>'
                    )
                  ),
                  array(
                    'core/list-item',
                    array(
                      'content' => '<a href="#"><strong>Link</strong></a>'
                    )
                  ),
                )
              )
            )
          ),
          array(
            'core/column',
            array(),
            array(
              array(
                'core/heading',
                array(
                  'placeholder' => 'Menu Heading',
                  'textColor' => 'gray-60',
                  'fontSize' => 'small',
                )
              ),
              array(
                'core/list',
                array(
                  'className' => 'is-style-unstyled'
                ),
                array(
                  array(
                    'core/list-item',
                    array(
                      'content' => '<a href="#"><strong>Link</strong></a>'
                    )
                  ),
                  array(
                    'core/list-item',
                    array(
                      'content' => '<a href="#"><strong>Link</strong></a>'
                    )
                  ),
                )
              )
            )
          ),
          array(
            'core/column',
            array(),
            array(
              array(
                'core/heading',
                array(
                  'placeholder' => 'Menu Heading',
                  'textColor' => 'gray-60',
                  'fontSize' => 'small',
                )
              ),
              array(
                'core/list',
                array(
                  'className' => 'is-style-unstyled'
                ),
                array(
                  array(
                    'core/list-item',
                    array(
                      'content' => '<a href="#"><strong>Link</strong></a>'
                    )
                  ),
                  array(
                    'core/list-item',
                    array(
                      'content' => '<a href="#"><strong>Link</strong></a>'
                    )
                  ),
                )
              )
            )
          ),
          array(
            'core/column',
            array(),
            array(
              array(
                'core/heading',
                array(
                  'placeholder' => 'Menu Heading',
                  'textColor' => 'gray-60',
                  'fontSize' => 'small',
                )
              ),
              array(
                'core/list',
                array(
                  'className' => 'is-style-unstyled'
                ),
                array(
                  array(
                    'core/list-item',
                    array(
                      'content' => '<a href="#"><strong>Link</strong></a>'
                    )
                  ),
                  array(
                    'core/list-item',
                    array(
                      'content' => '<a href="#"><strong>Link</strong></a>'
                    )
                  ),
                )
              )
            )
          ),
        )
      )
    )
  )
  );
}

add_action( 'init', 'ucla_mega_menu_cpt', 0 );
function ucla_mega_menu_location() {
  add_theme_page(
    'Mega Menu',
    'Mega Menu',
    'edit_theme_options',
    'edit.php?post_type=ucla-mega-menu',
  );
}
add_action( 'admin_menu', 'ucla_mega_menu_location' );

/**
 * Add custom fields to the menu item in the menu editor.
 *
 * @param int    $item_id  The ID of the menu item.
 * @param object $item     The menu item object.
 * @param int    $depth    The depth of the menu item.
 * @param array  $args     An array of arguments.
 */
function ucla_add_menu_items_custom_fields($item_id, $item, $depth, $args) {
  $selectedMegaMenu = get_post_meta($item_id, '_menu-item-mega-menu-select', true);
?>
<!-- Mega menu select -->
<p class="menu-item__custom-field field--mega-menu-select description description-wide">
		<label>
			<?php _e("Mega Menu Select (Main menu only)", 'ucla-wordpress'); ?> <br>
			<select class="widefat" name="menu-item-mega-menu-select[<?php echo $item_id; ?>]" id="menu-item-mega-menu-select-<?php echo $item_id; ?>">
				<option value="" <?php selected($selectedMegaMenu, '') ?>> None </option>
				<?php
				$args = array(
					'post_type' => 'ucla-mega-menu',
					'post_status' => 'publish',
					'posts_per_page' => -1,
				);
				$the_query = new WP_Query($args); ?>
				<?php if ($the_query->have_posts()) : ?>
					<?php while ($the_query->have_posts()) : $the_query->the_post(); ?>
						<option value="<?php echo get_the_ID() ?>" <?php selected($selectedMegaMenu, get_the_ID()) ?>>
							<?php echo get_the_title() ?>
						</option>
					<?php endwhile; ?>
					<?php wp_reset_postdata(); ?>
				<?php endif; ?>
			</select>
		</label>
	</p>
<?php
}
add_action('wp_nav_menu_item_custom_fields', 'ucla_add_menu_items_custom_fields', 10, 4);

/**
 * Save custom fields for menu items when a menu is updated.
 *
 * @param int   $menu_id          The ID of the updated menu.
 * @param int   $menu_item_db_id  The ID of the menu item being updated.
 * @param array $args             An array of arguments.
 */
function ucla_update_menu_items_custom_field($menu_id, $menu_item_db_id, $args) {
  $fields = array('mega-menu-select');

	foreach ($fields as $key) {
		$value = (isset($_POST['menu-item-' . $key][$menu_item_db_id])) ? $_POST['menu-item-' . $key][$menu_item_db_id] : '';
		update_post_meta($menu_item_db_id, '_menu-item-' . $key, $value);
	}
}
add_action('wp_update_nav_menu_item', 'ucla_update_menu_items_custom_field', 10, 3);

if (!class_exists('Ucla_Remove_Mega_Menu_From_Screen')) {
  class Ucla_Remove_Mega_Menu_From_Screen {
    function __construct() {
      add_action('in_admin_header', array($this, 'in_admin_header'));
    }
    function in_admin_header() {
      global $wp_meta_boxes;
      // echo '<pre>';
      // var_dump($wp_meta_boxes[get_current_screen()->id]['side']['default']['add-post-type-ucla-mega-menu']);

      // echo '</pre>';
      unset($wp_meta_boxes[get_current_screen()->id]['side']['default']['add-post-type-ucla-mega-menu']);
    }
  }
}
new Ucla_Remove_Mega_Menu_From_Screen();
