<?php

if (!function_exists('get_breadcrumbs')) {
  function get_breadcrumbs($classes = null)
  {
    global $post;
    $home_url = get_bloginfo('url');
    if (is_front_page()) {
      return;
    }
    $list_classes = $classes ? ' ' . esc_attr($classes) : '';
    
    echo '<nav class="ucla-breadcrumb'.$list_classes.'"><ul class="ucla-breadcrumb__list">';
    echo '<li class="ucla-breadcrumb__list-item">
            <a class="ucla-breadcrumb__link" href="' . $home_url . '">Home</a>
          </li>';
    if (is_single()) {
      // Get posts type
      $post_type = get_post_type();
      if ($post_type != 'post') {
        $post_type_object   = get_post_type_object($post_type);
        $post_type_link     = get_post_type_archive_link($post_type);

        echo '<li class="ucla-breadcrumb__list-item"><a class="ucla-breadcrumb__link" href="' . $post_type_link . '">' . $post_type_object->labels->name . '</a></li>';
      }
    }
    if (is_category()) {
      $category = get_category(get_query_var('cat'), false);
      if ($category->parent != 0) {
        $category_values      = array_values($category);
        $get_last_category    = end($category_values);
        $get_parent_category  = rtrim(get_category_parents($get_last_category->term_id, true, ','), ',');
        $cat_parent           = explode(',', $get_parent_category);
        foreach ($cat_parent as $p) {
          echo '<li class="ucla-breadcrumb__list-item">' . $p . '</li>';
        }
      }
    }

    if (is_page()) {
      if ($post->post_parent) {
        // If child page, get parents
        $anc = get_post_ancestors($post->ID);

        // Get parents in the right order
        $anc = array_reverse($anc);

        // Parent page loop
        if (!isset($parents)) $parents = null;
        foreach ($anc as $ancestor) {

          $parents .= '<li class="ucla-breadcrumb__list-item"><a class="ucla-breadcrumb__link" href="' . get_permalink($ancestor) . '">' . get_the_title($ancestor) . '</a></li>';
        }

        // Display parent pages
        echo $parents;
      }
    }
    if (is_archive()) {

      if (is_tax()) {
        // Get posts type
        $post_type = get_post_type();
        // If post type is not post
        if ($post_type != 'post') {

          $post_type_object   = get_post_type_object($post_type);
          $post_type_link     = get_post_type_archive_link($post_type);

          if ($post_type_object) {
            echo '<li class="ucla-breadcrumb__list-item breadcrumb__item--category breadcrumb__item--custom-post-type-' . $post_type . '"><a class="ucla-breadcrumb__link" href="' . $post_type_link . '">' . $post_type_object->labels->name . '</a></li>';
          }
        }

        // $custom_tax_name = get_queried_object()->name;

        // echo '<li class="ucla-breadcrumb__list-item breadcrumb__item--current">' . $custom_tax_name . '</li>';
      } else if (is_category()) {

        $parent = get_queried_object()->category_parent;
        if ($parent !== 0) {

          $parent_category = get_category($parent);
          $category_link   = get_category_link($parent);

          echo '<li class="breadcrumb__item"><a class="ucla-breadcrumb__link" href="' . esc_url($category_link) . '">' . $parent_category->name . '</a></li>';
        }

        // echo '<li class="ucla-breadcrumb__list-item breadcrumb__item--current">' . single_cat_title('', false) . '</li>';
      } else if (is_tag()) {

        // Get tag information
        $term_id        = get_query_var('tag_id');
        $taxonomy       = 'post_tag';
        $args           = 'include=' . $term_id;
        $terms          = get_terms($taxonomy, $args);
        $get_term_name  = $terms[0]->name;
      } else if (is_day()) {

        // Day archive

        // Year link
        echo '<li class="ucla-breadcrumb__list-item breadcrumb__item--year breadcrumb__item"><a class="ucla-breadcrumb__link" href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . ' Archives</a></li>';

        // Month link
        echo '<li class="ucla-breadcrumb__list-item breadcrumb__item--month breadcrumb__item"><a class="ucla-breadcrumb__link" href="' . get_month_link(get_the_time('Y'), get_the_time('m')) . '">' . get_the_time('M') . ' Archives</a></li>';

        // Day display
        echo '<li class="ucla-breadcrumb__list-item breadcrumb__item--current breadcrumb__item">' . get_the_time('jS') . ' ' . get_the_time('M') . ' Archives</li>';
      } else if (is_month()) {

        // Month archive

        // Year link
        echo '<li class="breadcrumb__item--year ucla-breadcrumb__list-item"><a class="ucla-breadcrumb__link" href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . ' Archives</a></li>';
      } else if (is_author()) {

        // Auhor archive

        // Get the author information
        global $author;
        $userdata = get_userdata($author);
      }
    }

    echo '</ul></nav>';
  }
}
