<?php

/**
 * Function that handles Customized Appearance
 * 
 * @package WordPress
 */
function ucla_sanitize_image( $file, $setting ) {

	$mimes = array(
		'jpg|jpeg|jpe' => 'image/jpeg',
		'gif'          => 'image/gif',
		'png'          => 'image/png',
		'bmp'          => 'image/bmp',
		'tif|tiff'     => 'image/tiff',
		'ico'          => 'image/x-icon',
    'svg'          => 'image/svg+xml',
	);

	//check file type from file name
	$file_ext = wp_check_filetype( $file, $mimes );

	//if file has a valid mime type return it, otherwise return default
	return ( $file_ext['ext'] ? $file : $setting->default );
}

function ucla_customizer_settings($wp_customize) {
  
  $wp_customize->add_setting(
    'ucla_mobile_logo',
    array(
        'sanitize_callback' => 'ucla_sanitize_image', // you can also use 'theme_mod'
        'capability' => 'edit_theme_options',
        'type' => 'theme_mod',
    ),
  );
  
  $wp_customize->add_setting(
    'ucla_footer_logo',
    array(
        'sanitize_callback' => 'ucla_sanitize_image', // you can also use 'theme_mod'
        'capability' => 'edit_theme_options',
        'type' => 'theme_mod',
    ),
  );
  
  $wp_customize->add_setting(
    'ucla_footer_mobile_logo',
    array(
        'sanitize_callback' => 'ucla_sanitize_image', // you can also use 'theme_mod'
        'capability' => 'edit_theme_options',
        'type' => 'theme_mod',
    ),
  );
  
  $wp_customize->add_setting('ucla_gtm_id', array(
    'type' => 'theme_mod',
    'transport' => 'postMessage',
    'sanitize_callback' => 'sanitize_textarea_field'
  ));

  $wp_customize->add_control('ucla_gtm_id', array(
    'label' => __('Google Tag Manager ID', 'ucla-wordpress'),
    'type' => 'text',
    'section' => 'ucla_theme_options',
    'settings' => 'ucla_gtm_id'
  ));
  $wp_customize->add_setting('ucla_header_type', array(
    'type' => 'theme_mod',
    'default' => 'box-logo-header',
    'transport' => 'refresh'
  ));
  $wp_customize->add_control(
    new WP_Customize_Control(
      $wp_customize,
      'ucla_header_type',
      array(
        'label' => __('Header Type', 'ucla-wordpress'),
        'type' => 'select',
        'choices' => array(
          'box-logo-header' => 'Box Header',
          'text-logo-header' => 'Text Header'
        ),
        'section' => 'title_tagline',
        'settings' => 'ucla_header_type',
        'priority' => 0,
      )
    )
  );
  $wp_customize->add_control(
    new WP_Customize_Image_Control(
      $wp_customize,
      'ucla_mobile_logo',
      array(
        'label' => __('Logo for mobile (Optional)', 'ucla-wordpress'),
        'section' => 'title_tagline',
        'settings' => 'ucla_mobile_logo',
        'priority' => 10,
      )
    )
      );
  $wp_customize->add_control(
    new WP_Customize_Image_Control(
      $wp_customize,
      'ucla_footer_logo',
      array(
        'label' => __('Footer Logo', 'ucla-wordpress'),
        'section' => 'title_tagline',
        'settings' => 'ucla_footer_logo',
        'priority' => 10,
      )
    )
  );
  $wp_customize->add_control(
    new WP_Customize_Image_Control(
      $wp_customize,
      'ucla_footer_mobile_logo',
      array(
        'label' => __('Footer Logo for mobile (Optional)', 'ucla-wordpress'),
        'section' => 'title_tagline',
        'settings' => 'ucla_footer_mobile_logo',
        'priority' => 10,
      )
    )
  );
  $wp_customize->add_setting('ucla_footer_address', array(
    'type' => 'theme_mod',
    'transport' => 'postMessage',
    'sanitize_callback' => 'sanitize_textarea_field'
  ));

  $wp_customize->add_control('ucla_footer_address', array(
    'label' => __('Department Address', 'ucla-wordpress'),
    'type' => 'textarea',
    'section' => 'ucla_theme_options',
    'settings' => 'ucla_footer_address'
  ));
  $wp_customize->add_setting('ucla_footer_phone', array(
    'type' => 'theme_mod',
    'transport' => 'postMessage',
  ));
  $wp_customize->add_control('ucla_footer_phone', array(
    'label' => __('Department Phone Number', 'ucla-wordpress'),
    'type' => 'text',
    'section' => 'ucla_theme_options',
    'settings' => 'ucla_footer_phone'
  ));
  $wp_customize->add_setting('ucla_footer_email', array(
    'type' => 'theme_mod',
    'transport' => 'postMessage',
  ));
  $wp_customize->add_control('ucla_footer_email', array(
    'label' => __('Department Contact Email', 'ucla-wordpress'),
    'type' => 'email',
    'section' => 'ucla_theme_options',
    'settings' => 'ucla_footer_email'
  ));
  $wp_customize->add_setting('ucla_dept_facebook', array(
    'type' => 'theme_mod',
    'transport' => 'postMessage',
  ));
  $wp_customize->add_control('ucla_dept_facebook', array(
    'label' => __('Facebook Page', 'ucla-wordpress'),
    'description' => __('Enter the full URL.<br />Example: https://www.facebook.com/ucla', 'ucla-wordpress'),
    'type' => 'url',
    'section' => 'ucla_social_media',
    'settings' => 'ucla_dept_facebook'
  ));

  $wp_customize->add_setting('ucla_dept_twitterx', array(
    'type' => 'theme_mod',
    'transport' => 'postMessage',
  ));
  $wp_customize->add_control('ucla_dept_twitterx', array(
    'label' => __('Twitter Page', 'ucla-wordpress'),
    'description' => __('Enter the full URL.<br />Example: https://www.twitter.com/ucla', 'ucla-wordpress'),
    'type' => 'url',
    'section' => 'ucla_social_media',
    'settings' => 'ucla_dept_twitterx'
  ));
  $wp_customize->add_setting('ucla_dept_instagram', array(
    'type' => 'theme_mod',
    'transport' => 'postMessage',
  ));
  $wp_customize->add_control('ucla_dept_instagram', array(
    'label' => __('Instagram Page', 'ucla-wordpress'),
    'description' => __('Enter the full URL.<br />Example: https://www.instagram.com/ucla', 'ucla-wordpress'),
    'type' => 'url',
    'section' => 'ucla_social_media',
    'settings' => 'ucla_dept_instagram'
  ));
  $wp_customize->add_setting('ucla_dept_linkedin', array(
    'type' => 'theme_mod',
    'transport' => 'postMessage',
  ));
  $wp_customize->add_control('ucla_dept_linkedin', array(
    'label' => __('Linkedin Page', 'ucla-wordpress'),
    'description' => __('Enter the full URL.<br />Example: https://www.linkedin.com/company/ucla', 'ucla-wordpress'),
    'type' => 'url',
    'section' => 'ucla_social_media',
    'settings' => 'ucla_dept_linkedin'
  ));
  $wp_customize->add_setting('ucla_dept_youtube', array(
    'type' => 'theme_mod',
    'transport' => 'postMessage',
  ));
  $wp_customize->add_control('ucla_dept_youtube', array(
    'label' => __('YouTube Page', 'ucla-wordpress'),
    'description' => __('Enter the full URL.<br />Example: https://www.youtube.com/user/UCLA', 'ucla-wordpress'),
    'type' => 'url',
    'section' => 'ucla_social_media',
    'settings' => 'ucla_dept_youtube'
  ));
  $wp_customize->add_setting('ucla_dept_tiktok', array(
    'type' => 'theme_mod',
    'transport' => 'postMessage',
  ));
  $wp_customize->add_control('ucla_dept_tiktok', array(
    'label' => __('TikTok Page', 'ucla-wordpress'),
    'description' => __('Enter the full URL.<br />Example: https://www.tiktok.com/@ucla', 'ucla-wordpress'),
    'type' => 'url',
    'section' => 'ucla_social_media',
    'settings' => 'ucla_dept_tiktok'
  ));
  $wp_customize->add_setting('ucla_dept_bluesky', array(
    'type' => 'theme_mod',
    'transport' => 'postMessage',
  ));
  $wp_customize->add_control('ucla_dept_bluesky', array(
    'label' => __('BlueSky Page', 'ucla-wordpress'),
    'description' => __('Enter the full URL.<br />Example: https://bsky.app/profile/deptprofile.bsky.social', 'ucla-wordpress'),
    'type' => 'url',
    'section' => 'ucla_social_media',
    'settings' => 'ucla_dept_bluesky'
  ));
  $wp_customize->add_section(
    'ucla_theme_options',
    array(
      'title' => __('Theme Options', 'ucla-wordpress'),
      'priority' => 105,
    )
  );
  $wp_customize->add_section(
    'ucla_social_media',
    array(
      'title' => __('Social Media', 'ucla-wordpress'),
      'priority' => 110,
    )
  );
  $logo_controls = array_filter(
    array(
      $wp_customize->get_control('custom_logo'),
      $wp_customize->get_control('ucla_mobile_logo'),
    )
  );
  foreach ($logo_controls as $logo_control) {
    $logo_control->active_callback = 'get_logo_control_active_state';
  }
}

add_action('customize_register', 'ucla_customizer_settings');

function get_logo_control_active_state($control) {
  $setting = $control->manager->get_setting('ucla_header_type');
  
  if (! $setting) {
    return true;
  }
  return 'box-logo-header' !== $setting->value();
}

function customize_controls_enqueue_scripts() {
	$handle = 'dependently-contextual-logo-customizer-controls';
	$src = get_template_directory_uri() . '/inc/customize-appearance-logo.js';
	$deps = array( 'customize-controls' );
	$ver = false;
	wp_enqueue_script( $handle, $src, $deps, $ver );
}
add_action( 'customize_controls_enqueue_scripts', 'customize_controls_enqueue_scripts' );