(
  function(api) {
    'use strict';

    // Add callback for when Box Logo is selected.
    api('ucla_header_type', function(setting) {
      let isBoxHeader, linkSettingValueToControlActiveState;

      /**
       * Determines whether the logo uploads should be displayed.
       * 
       */
      isBoxHeader = function() {
        return 'box-logo-header' == setting.get();
      }
      /**
       * Update a control's active state according to the ucla_header_type setting's value.
       */
      linkSettingValueToControlActiveState = function(control) {
        let setActiveState = function() {
          control.active.set(isBoxHeader());
        }

        // Note: With the following we can eliminate all of our PHP active_callback code.
        control.active.validate = isBoxHeader;

        // Set initial active state.
        setActiveState();

        /*
        * Update activate state whenever the setting is changed.
        * Even when the setting does have a refresh transport where the
        * server-side active callback will manage the active state upon
        * refresh, having this JS management of the active state will
        * ensure that controls will have their visibility toggled
        * immediately instead of waiting for the preview to load.
        * This is especially important if the setting has a postMessage
        * transport where changing the setting wouldn't normally cause
        * the preview to refresh and thus the server-side active_callbacks
        * would not get invoked.
        */
        setting.bind(setActiveState);
      }

      // Call linkSettingValueToControlActiveState on logo controls when box header exists.
      api.control('custom_logo', linkSettingValueToControlActiveState);
      api.control('ucla_mobile_logo', linkSettingValueToControlActiveState);
    })
  }(wp.customize)
);