<?php

/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 */
$ucla_gtm_id = get_theme_mod('ucla_gtm_id');
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo('charset'); ?>" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <?php wp_head(); ?>
  <link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo('stylesheet_url'); ?>" />
  <?php if (! has_site_icon() && ! is_customize_preview() ) : ?>
    <link rel="icon" type="image/png" sizes="32x32" href="<?= get_template_directory_uri() . '/assets/images/favicon-32x32.png'; ?>" />
    <link rel="apple-touch-icon" href="<?= get_template_directory_uri() . '/assets/images/apple-touch-icon.png'; ?>" />
    <link rel="manifest" href="<?= get_template_directory_uri() . '/assets/manifest-ucla.json'; ?>">
  <?php else:
  wp_site_icon();
  endif; ?>
  <?php if ($ucla_gtm_id) : ?>
    <!-- Start Google Tag Manager -->
    <script>
      (function(w, d, s, l, i) {
        w[l] = w[l] || [];
        w[l].push({
          'gtm.start': new Date().getTime(),
          event: 'gtm.js'
        });
        var f = d.getElementsByTagName(s)[0],
          j = d.createElement(s),
          dl = l != 'dataLayer' ? '&l=' + l : '';
        j.async = true;
        j.src =
          'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
        f.parentNode.insertBefore(j, f);
      })(window, document, 'script', 'dataLayer', '<?= $ucla_gtm_id ?>');
    </script>
    <!-- End Google Tag Manager -->
  <?php endif; ?>
</head>

<body <?php body_class(); ?>>
  <a class="skip-nav__link" href="#main"><?php _e('Skip to Main Content', 'ucla-wordpress') ?></a>
  <?php if ($ucla_gtm_id) : ?>
    <!-- Start Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=<?= $ucla_gtm_id ?>" height="0" width="0" style="display:none;visibility:hidden" title="Google Tag Manager" aria-hidden="true"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->
  <?php endif; ?>
  <?php
  wp_body_open();
  get_template_part('template-parts/header/' . get_theme_mod('ucla_header_type', 'box-logo-header'));
  ?>