<?php

/**
 * UCLA Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 */
if (!function_exists('ucla_wordpress_setup')) :
  function ucla_wordpress_setup()
  {
    /*
    * Enable support for Post Thumbnails on posts and pages.
    *
    * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
    */
    add_theme_support('post-thumbnails');
    add_theme_support('title-tag');
    add_theme_support('wp-block-styles');
    add_theme_support( 'custom-logo' );
    remove_theme_support( 'widgets-block-editor' );

    register_nav_menus(array(
      'main-menu' => esc_html__('Main Menu', 'ucla-wordpress'),
      'secondary-menu' => esc_html__('Secondary Menu', 'ucla-wordpress'),
      'footer-menu' => esc_html__('Footer Menu', 'ucla-wordpress')
    ));
  }
endif;
add_action('after_setup_theme', 'ucla_wordpress_setup');
if (!function_exists('ucla_wordpress_styles')) :
  function ucla_wordpress_styles()
  {
    $theme_version = wp_get_theme()->get('Version');
    $version_string = is_string($theme_version) ? $theme_version : false;
    wp_register_style(
      'ucla-wordpress-style',
      'https://cdn.designsystem.brand.ucla.edu/build/v2.6.0/css/ucla-lib.min.css',
      array(),
      $version_string
    );
    wp_register_style(
      'ucla-wordpress-global-style',
      get_template_directory_uri() . '/assets/css/global.css',
      array('ucla-wordpress-style'),
      $version_string
    );
    wp_register_style(
      'ucla-wordpress-header-style',
      get_template_directory_uri() . '/assets/css/header.css',
      array('ucla-wordpress-style'),
      $version_string
    );
    wp_register_style(
      'ucla-wordpress-footer-style',
      get_template_directory_uri() . '/assets/css/footer.css',
      array('ucla-wordpress-style'),
      $version_string
    );
    wp_register_style(
      'ucla-wordpress-template-style',
      get_template_directory_uri() . '/assets/css/templates.css',
      array('ucla-wordpress-style'),
      $version_string
    );
    wp_register_script(
      'ucla_wordpress_scripts',
      'https://cdn.designsystem.brand.ucla.edu/build/v2.6.0/js/ucla-lib-scripts.min.js',
      array(),
      $version_string,
      true
    );
    // Enqueue theme stylesheet.
    wp_enqueue_style('ucla-wordpress-style');
    wp_enqueue_style('ucla-wordpress-global-style');
    wp_enqueue_style('ucla-wordpress-header-style');
    wp_enqueue_style('ucla-wordpress-footer-style');
    wp_enqueue_style('ucla-wordpress-template-style');
    wp_enqueue_script('ucla_wordpress_scripts');
    wp_add_inline_script('ucla_wordpress_scripts', 'Bruin.init();', 'after');
    wp_deregister_style('common');
  }
endif;

add_action('wp_enqueue_scripts', 'ucla_wordpress_styles');

// Register sidebar widget
function ucla_sidebar_widget() {
  register_sidebar(array(
    'name'  =>  __( 'Main Sidebar', 'ucla-wordpress' ),
    'description' => __('The content in this widget will go in the sidebar templates below the side navigation.', 'ucla-wordpress'),
    'id'    =>  'ucla-sidebar',
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
    'class' => 'ucla-prose mt-5',
    'before_sidebar' => '<div id="%1$s" class="%2$s">',
    "after_sidebar" => '</div>'
  ));
}
add_action('widgets_init', 'ucla_sidebar_widget');

function ucla_wordpress_add_editor_styles()
{
  add_theme_support('editor-styles');
  add_editor_style('editor-style.css');
}
add_action('admin_init', 'ucla_wordpress_add_editor_styles');

function ucla_remove_core_block_patterns()
{
  remove_theme_support('core-block-patterns');
}
add_action('init', 'ucla_remove_core_block_patterns');

// Add Class to Nav List
function add_additional_class_on_li($classes, $item, $args)
{
  if (isset($args->list_class)) {
    $classes[] = $args->list_class;
  }
  return $classes;
}
add_filter('nav_menu_css_class', 'add_additional_class_on_li', 1, 3);

function add_additional_class_on_anchor($classes, $item, $args)
{
  if (isset($args->link_class)) {
    $classes['class'] = $args->link_class;
  }
  return $classes;
}
add_filter('nav_menu_link_attributes', 'add_additional_class_on_anchor', 1, 3);

// Allow SVG uploads through Media Uploader
function cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');

// fileinfo PHP fix
function correct_svg_filetypes( $data, $file, $filename, $mimes, $real_mime ) {

  if ( ! empty( $data['ext'] ) && ! empty( $data['type'] ) ) {
    return $data;
  }

  $wp_file_type = wp_check_filetype( $filename, $mimes );

  // Check for the file type you want to enable, e.g. 'svg'.
  if ( 'svg' === $wp_file_type['ext'] ) {
    $data['ext']  = 'svg';
    $data['type'] = 'image/svg+xml';
  }

  return $data;
}
add_filter( 'wp_check_filetype_and_ext', 'correct_svg_filetypes', 10, 5 );

/**
 *  Filters the excerpt [...] string to just ...
 */
function wpdocs_excerpt_more( $more ) {
	return '...';
}
add_filter( 'excerpt_more', 'wpdocs_excerpt_more' );

add_filter( 'get_the_archive_title_prefix', '__return_empty_string' );

// Custom Walker Navigation (Primary Nav)
require get_template_directory() . '/classes/class-ucla-wordpress-primary-navigation-walker.php';

// Custom Walker Navigation (Secondary Nav)
require get_template_directory() . '/classes/class-ucla-wordpress-secondary-navigation-walker.php';

// Custom Walker Navigation (Side Nav)
require get_template_directory() . '/classes/class-ucla-wordpress-side-navigation-walker.php';

// Custom Walker Navigation (Footer nav)
require get_template_directory() . '/classes/class-ucla-wordpress-footer-navigation-walker.php';

// Include Customize Appearance
require get_template_directory() . '/inc/customize-appearance.php';

// Include Post In Side Navigation
require get_template_directory() . '/inc/post-in-side-navigation.php';

// Include Breadcrumbs
require get_template_directory() . '/inc/get-breadcrumbs.php';

// Include Cover Block Extension
require get_template_directory() . '/inc/video-cover-block-accessibility-extension.php';

// Include Mega Menu
require get_template_directory() . '/inc/mega-menu.php';