<?php

/**
 * Custom Navigation Walker
 *
 * @package WordPress
 */

/**
 * This class is in charge of the Secondary Navigation HTML.
 */
class Ucla_Wordpress_Secondary_Navigation_Walker extends Walker_Nav_Menu
{

  /**
   * @see Walker::display_element()
   * @since 2.5.0
   *
   * @param object $element           Data object.
   * @param array  $children_elements List of elements to continue traversing (passed by reference).
   * @param int    $max_depth         Max depth to traverse.
   * @param int    $depth             Depth of current element.
   * @param array  $args              An array of arguments.
   * @param string $output            Used to append additional content (passed by reference).
   */

  function display_element($element, &$children_elements, $max_depth, $depth, $args, &$output)
  {
    $id_field = $this->db_fields['id'];
    if (is_object($args[0])) {
      $args[0]->has_children = !empty($children_elements[$element->$id_field]);
    }
    return parent::display_element($element, $children_elements, $max_depth, $depth, $args, $output);
  }

  /**
   * @see Walker::start_el()
   * @since 3.0.0
   *
   * @param string $output Passed by reference. Used to append additional content.
   * @param object $item Menu item data object.
   * @param int $depth Depth of menu item. Used for padding.
   * @param int $current_page Menu item ID.
   * @param object $args
   */

  function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0)
  {
    if ($depth !== 0) {
      return;
    }
    $indent = ($depth) ? str_repeat("\t", $depth) : '';
    $class_names = $value = '';
    $list_classes = empty($item->classes) ? array() : (array) $item->classes;
    $list_classes[] = 'ucla-secondary-nav__item menu-item-' . $item->ID;
    $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($list_classes), $item, $args));
    $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
    $output .= $indent . '<li' . $class_names . '>';
    $link_attribute = !empty($item->attr_title) ? ' title="'  . esc_attr($item->attr_title) . '"' : '';
    $link_attribute .= !empty($item->target)     ? ' target="' . esc_attr($item->target) . '"' : '';
    $link_attribute .= !empty($item->xfn)        ? ' rel="'    . esc_attr($item->xfn) . '"' : '';
    $link_attribute .= !empty($item->url)        ? ' href="'   . esc_attr($item->url) . '"' : '';
    //$link_attribute .= ' class="ucla-main-nav__link' . (in_array("current_page_item", $item->classes) || in_array("current-menu-parent", $item->classes) ? ' ucla-main-nav__link--current-page' : '') . '"';
    $link_attribute .= ' class="ucla-secondary-nav__link"';
    $item_output = '<a' . $link_attribute . '>';
    $item_output .= apply_filters('the_title', $item->title, $item->ID);
    $item_output .= '</a>';

    $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
  }

  /**
   * @see Walker::end_el()
   * @since 3.0.0
   *
   * @param string $output Passed by reference. Used to append additional content.
   * @param object $item Page data object. Not used.
   * @param int $depth Depth of page. Not Used.
   */

  function end_el(&$output, $item, $depth = 0, $args = array())
  {
    $output .= "</li>\n";
  }

  /**
   * @see Walker::start_lvl()
   * @since 3.0.0
   *
   * @param string $output Passed by reference. Used to append additional content.
   * @param int $depth Depth of page. Used for padding.
   */

  function start_lvl(&$output, $depth = 0, $args = array())
  {
    return;
  }

  /**
   * @see Walker::end_lvl()
   * @since 3.0.0
   *
   * @param string $output Passed by reference. Used to append additional content.
   * @param int $depth Depth of page. Used for padding.
   */

  function end_lvl(&$output, $depth = 0, $args = array())
  {
    return;
  }
}
