<?php

/**
 * Custom Navigation Walker
 *
 * @package WordPress
 */

/**
 * This class is in charge of the Primary Navigation HTML.
 */
class Ucla_Wordpress_Footer_Navigation_Walker extends Walker_Nav_Menu
{
  /**
   * @see Walker::display_element()
   * @since 2.5.0
   *
   * @param object $element           Data object.
   * @param array  $children_elements List of elements to continue traversing (passed by reference).
   * @param int    $max_depth         Max depth to traverse.
   * @param int    $depth             Depth of current element.
   * @param array  $args              An array of arguments.
   * @param string $output            Used to append additional content (passed by reference).
   */

  function display_element($element, &$children_elements, $max_depth, $depth, $args, &$output)
  {
    $id_field = $this->db_fields['id'];
    if (is_object($args[0])) {
      $args[0]->has_children = !empty($children_elements[$element->$id_field]);
    }
    return parent::display_element($element, $children_elements, $max_depth, $depth, $args, $output);
  }
  /**
   * @see Walker::start_el()
   * @since 3.0.0
   *
   * @param string $output Passed by reference. Used to append additional content.
   * @param object $item Menu item data object.
   * @param int $depth Depth of menu item. Used for padding.
   * @param int $current_page Menu item ID.
   * @param object $args
   */

  function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0)
  {
    $class_names = $value = '';
    $list_classes = empty($item->classes) ? array() : (array) $item->classes;
    $list_classes[] = $item->ID;

    $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($list_classes), $item, $args));
    if ($depth == 0) {
      $class_names = $class_names ? ' class="ucla-dept-footer__nav-column ' . esc_attr($class_names) . '"' : '';
      $output .= '<div' . $class_names . '>';
    } else {
      $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';

      $output .= '<li' . $class_names . '>';
    }

    $attributes  = '';
    !empty($item->attr_title) and $attributes .= ' title="'  . esc_attr($item->attr_title) . '"';
    !empty($item->target) and $attributes .= ' target="' . esc_attr($item->target) . '"';
    !empty($item->xfn) and $attributes .= ' rel="'    . esc_attr($item->xfn) . '"';
    !empty($item->url) and $attributes .= ' href="'   . esc_attr($item->url) . '"';
    $title = apply_filters('the_title', $item->title, $item->ID);
    $item_output = $args->before;
    if ($depth == 0) {
      if ($item->url && $item->url != '#') {
        $item_output .= '<p class="tertiary-nav-header"><a' . $attributes . '>';
        $item_output .= $args->link_before . $title . $args->link_after;
        $item_output .= '</a></p>';
      } else {
        $item_output .= '<p class="tertiary-nav-header">';
        $item_output .= $title;
        $item_output .= '</p>';
      }
    } else {
      $item_output .= '<a' . $attributes . '>';
      $item_output .= $args->link_before . $title . $args->link_after;
      $item_output .= '</a>';
    }
    $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
  }

  function start_lvl(&$output, $depth = 0, $args = array())
  {
    $indent = str_repeat("\t", $depth);
    $output .= "\n<ul class='ucla-dept-footer__nav'>$indent</li>\n";
  }

  /**
   * @see Walker::end_lvl()
   * @since 3.0.0
   *
   * @param string $output Passed by reference. Used to append additional content.
   * @param int $depth Depth of page. Used for padding.
   */

  function end_lvl(&$output, $depth = 0, $args = array())
  {
    $indent = str_repeat("\t", $depth);
    $output .= "$indent</ul>\n";
  }

  function end_el(&$output, $item, $depth = 0, $args = array())
  {
    if ($depth == 0) {
      $output .= "</div>\n";
    } else {
      $output .= "</li>\n";
    }
  }
}
