'use strict';
const videoControlButtons = document.querySelectorAll('.ucla__cover_button-control');

function handlePlayButton(video) {
  if (video.paused) {
    video.play();
  } else {
    video.pause();
  }
}
if (videoControlButtons.length > 0) {
  videoControlButtons.forEach(button => {
    button.addEventListener('click',(e)=> {
      e.stopPropagation();
      let video = e.currentTarget.parentNode.querySelector('video');
      let icon = e.currentTarget.querySelector('svg');
      let iconPlayPath = '<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="none"><g filter="url(#a)"><circle cx="19.999" cy="19.999" r="19.999" fill="#000" fill-opacity=".65"/></g><g filter="url(#b)"><path fill="#fff" d="m13.917 29.564 14.877-9.565-14.877-9.564v19.129Z"/></g><defs><filter id="a" width="47.999" height="47.999" x="-4" y="-4" color-interpolation-filters="sRGB" filterUnits="userSpaceOnUse"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feGaussianBlur in="BackgroundImageFix" stdDeviation="2"/><feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_2019_9"/><feBlend in="SourceGraphic" in2="effect1_backgroundBlur_2019_9" result="shape"/></filter><filter id="b" width="22.877" height="27.128" x="9.917" y="6.435" color-interpolation-filters="sRGB" filterUnits="userSpaceOnUse"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feGaussianBlur in="BackgroundImageFix" stdDeviation="2"/><feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_2019_9"/><feBlend in="SourceGraphic" in2="effect1_backgroundBlur_2019_9" result="shape"/></filter></defs></svg>';
      let iconPausePath = '<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="none"><g filter="url(#a)"><circle cx="19.999" cy="19.999" r="19.999" fill="#000" fill-opacity=".65"/></g><path fill="#fff" d="M13 29h5V11h-5v18ZM22 29h5V11h-5v18Z"/><defs><filter id="a" width="47.999" height="47.999" x="-4" y="-4" color-interpolation-filters="sRGB" filterUnits="userSpaceOnUse"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feGaussianBlur in="BackgroundImageFix" stdDeviation="2"/><feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_0_1"/><feBlend in="SourceGraphic" in2="effect1_backgroundBlur_0_1" result="shape"/></filter></defs></svg>';
      // let iconPlayPath = "M9.5 16.5L16.5 12L9.5 7.5L9.5 16.5ZM12 22C10.6167 22 9.31666 21.7373 8.1 21.212C6.88333 20.6873 5.825 19.975 4.925 19.075C4.025 18.175 3.31266 17.1167 2.788 15.9C2.26266 14.6833 2 13.3833 2 12C2 10.6167 2.26267 9.31667 2.788 8.1C3.31267 6.88333 4.025 5.825 4.925 4.925C5.825 4.025 6.88333 3.31233 8.1 2.787C9.31667 2.26233 10.6167 2 12 2C13.3833 2 14.6833 2.26234 15.9 2.787C17.1167 3.31234 18.175 4.025 19.075 4.925C19.975 5.825 20.6873 6.88334 21.212 8.1C21.7373 9.31667 22 10.6167 22 12C22 13.3833 21.7373 14.6833 21.212 15.9C20.6873 17.1167 19.975 18.175 19.075 19.075C18.175 19.975 17.1167 20.6873 15.9 21.212C14.6833 21.7373 13.3833 22 12 22ZM12 20C14.2333 20 16.125 19.225 17.675 17.675C19.225 16.125 20 14.2333 20 12C20 9.76667 19.225 7.875 17.675 6.325C16.125 4.775 14.2333 4 12 4C9.76667 4 7.875 4.775 6.325 6.325C4.775 7.875 4 9.76667 4 12C4 14.2333 4.775 16.125 6.325 17.675C7.875 19.225 9.76666 20 12 20Z"
      // let iconPausePath = "M9 16H11V8H9V16ZM12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM12 20C7.59 20 4 16.41 4 12C4 7.59 7.59 4 12 4C16.41 4 20 7.59 20 12C20 16.41 16.41 20 12 20ZM13 16H15V8H13V16Z";
      //handlePlayButton(video);
      if (video.paused) {
        try {
          video.play();
          e.currentTarget.classList.add('playing');
          icon.outerHTML=iconPausePath;
        } catch (err) {
          e.currentTarget.classList.remove('playing');
          icon.outerHTML=iconPlayPath;
        }
      } else {
        video.pause();
        e.currentTarget.classList.remove('playing');
        icon.outerHTML=iconPlayPath;
      }
    })
  });
}