import { __ } from '@wordpress/i18n';
import {
	store as editorStore,
} from '@wordpress/editor';
import {
  __experimentalToggleGroupControl as ToggleGroupControl,
  __experimentalToggleGroupControlOptionIcon as ToggleGroupControlOptionIcon,
} from '@wordpress/components';
import { useDispatch, useSelect } from '@wordpress/data';

const SelectDevice = (props) => {
  const { isBlock } = props;
  const deviceType = useSelect( ( select ) => {
		return select( 'core/editor' ).getDeviceType();
	}, [] );
	const { setDeviceType } = useDispatch( editorStore );
  
	const deviceIcon = {
		Desktop: 'desktop',
		Tablet: 'tablet',
		Mobile: 'smartphone',
	};

	return (
		<div className="responsive-controls-select-device-icon-group">
      <ToggleGroupControl
        isBlock={isBlock}
        value={deviceType}
        __nextHasNoMarginBottom
        __next40pxDefaultSize
        onChange={ (value) =>
          setDeviceType( value )
        }
      >
        {[ 'Desktop', 'Tablet', 'Mobile' ].map( ( deviceOption ) => 
          <ToggleGroupControlOptionIcon
            key={deviceOption}
            icon={ deviceIcon[ deviceOption ] }
            value={deviceOption}
            label={deviceOption}
          />
        )}
      </ToggleGroupControl>
		</div>
	);
}
export default SelectDevice;