import { __ } from '@wordpress/i18n';
import { useEffect, useState } from '@wordpress/element';
import {
  BaseControl,
  __experimentalNumberControl as NumberControl,
  __experimentalHStack as HStack
} from '@wordpress/components';
import SelectDevice from './select-device';

const ColumnOrder = (props) => {
  const {
		attributes,
		setAttributes,
    deviceType
	} = props;

  const { responsiveControls } = attributes;
  const [columnOrderValue, setColumnOrderValue] = useState(() => responsiveControls.order ? responsiveControls.order  : '');

  // const deviceType = useSelect( ( select ) => {
	// 	return select( 'core/editor' ).getDeviceType();
	// }, [] );

  const onOrderChange = value => {
    // console.log('onorderchange triggered')
    setColumnOrderValue(value);
    // console.log('column order style',style)
    switch (deviceType) {
      case 'Mobile':
        let mobileOrderStyles = responsiveControls;
        mobileOrderStyles = {...mobileOrderStyles, 'mobile': {...mobileOrderStyles?.mobile, 'order': value}}
        setAttributes({
          responsiveControls: mobileOrderStyles
        })
        break;
      case 'Tablet':
        let tabletOrderStyles = responsiveControls;
        tabletOrderStyles = {...tabletOrderStyles, 'tablet': {...tabletOrderStyles?.tablet, 'order': value}}
        setAttributes({
          responsiveControls: tabletOrderStyles
        })
        break;
      case 'Desktop':
        let desktopOrderStyles = responsiveControls;
        desktopOrderStyles = {...desktopOrderStyles, 'order': value}
        setAttributes({
          responsiveControls: desktopOrderStyles
        })
        break;
      default:
        console.log('Unknown Device Type: ', deviceType);
    }
    // console.log('deviceType',deviceType)
    // console.log('responsiveControls',responsiveControls)
  }

  useEffect(()=> {
    const {tablet, mobile, ...pruneStyles} = responsiveControls;
    // console.log('devicetype useeffect attr',attributes);
    // console.log('devicetype useeffect device',deviceType);
    switch (deviceType) {
      case 'Mobile':
        mobile && mobile.order ? setColumnOrderValue(mobile.order) : setColumnOrderValue('')
        break;
      case 'Tablet':
        tablet && tablet.order ? setColumnOrderValue(tablet.order) : setColumnOrderValue('')
        break;
      case 'Desktop':
        pruneStyles.order ? setColumnOrderValue(pruneStyles.order) : setColumnOrderValue('')
        break;
      default:
        console.log('Unknown Device Type: ', deviceType);
    }
  }, [deviceType])

  return (
      <BaseControl __nextHasNoMarginBottom className='ucla-responsive-column-order'>
        <HStack
          spacing={0}
          alignment='center'
          justify='flex-start'
        >
          <BaseControl.VisualLabel>Column Order</BaseControl.VisualLabel>
          <SelectDevice isBlock={false} />
        </HStack>
          <NumberControl
            __next40pxDefaultSize
            __nextHasNoMarginBottom
            value={columnOrderValue}
            onChange={value => onOrderChange(value)}
            type="number"
            max={12}
            min={-1}
          />
      </BaseControl>
  )
}

export default ColumnOrder;