import {
	applyFilters,
	addFilter,
} from '@wordpress/hooks';

import {
	// @ts-ignore
	hasBlockSupport,
} from '@wordpress/blocks';

import {
	Fragment
} from '@wordpress/element';

import {
	createHigherOrderComponent
} from '@wordpress/compose';

import InspectorControls from "./inc/inspector-controls";
import AnimatedBlockListBlock from "./animated-block-list-block";

const getMotionProps = motionForBlocks => {
	let motionProps = {};
	if (!motionForBlocks) {
		return motionProps;
	}

	return motionProps;
}

const featureName = 'motionForBlocks';
const featureDefaultEnabled = applyFilters('uclaMotionBlocks.defaultEnabled', true);
const featureIsSupported = block => {
	const name = block.name || block;
	if(window.uclaMotionData.unsupportedBlocks.includes(name)) {
		return false;
	}
	return hasBlockSupport(block, featureName, featureDefaultEnabled);
};
const featureAttributes = {
	motionForBlocks: {
		type: 'object',
		default: {},
	},
};

const withFeatureAttributes = function(settings) {
	if(featureIsSupported(settings)) {
		settings.attributes = Object.assign(settings.attributes || {}, featureAttributes);
	}

	return settings;
}

// const withFeatureInspectorControls = createHigherOrderComponent((BlockEdit) => {
// 	return (props) => {
// 		if(featureIsSupported(props.name)) {
// 			return (
// 				<Fragment>
// 					<BlockEdit {...props} />
// 					<InspectorControls {...props} />
// 				</Fragment>
// 			);
// 		}

// 		return <BlockEdit {...props} />;
// 	};
// }, 'withMotionForBlocksInspectorControls');

const withFeatureInspectorControls = createHigherOrderComponent(function(BlockEdit) {
	return function(props) {
		if(featureIsSupported(props.name)) {
			
			return (
				<Fragment>
					<BlockEdit {...props} />
					<InspectorControls {...props} />
				</Fragment>
			);
		}

		return <BlockEdit {...props} />;
	};
}, 'withMotionForBlocksInspectorControls');

const withMotionProps = (extraProps, blockType, attributes) => {
	if (featureIsSupported(blockType)) {
		let {motionForBlocks} = attributes;
		const motionProps = getMotionProps(motionForBlocks);
		if (motionProps) {
			extraProps = {
				...extraProps,
				...motionProps
			}
		}
	}
	return extraProps
}

// const withMotionBlockListBlock = createHigherOrderComponent(
// 	BlockListBlock => props => featureIsSupported(props.name) ? <AnimatedBlockListBlock {...props} BlockListBlock={BlockListBlock} /> : <BlockListBlock {...props} />, 'withMotionBlockListBlock'
// )

const withMotionBlockListBlock = createHigherOrderComponent( (BlockListBlock) => (props) => {	
	
	const wrapperProps = {
		...props.wrapperProps
	};
			
	return featureIsSupported(props.name) ? <AnimatedBlockListBlock {...props} BlockListBlock={BlockListBlock} wrapperProps={wrapperProps} /> : <BlockListBlock {...props} />

}, 'withMotionBlockListBlock')

addFilter('blocks.registerBlockType', 'ucla-wordpress-plugin/attributes', withFeatureAttributes);
addFilter('editor.BlockEdit', 'ucla-wordpress-plugin/inspector-controls', withFeatureInspectorControls);
addFilter('blocks.getSaveContent.extraProps', 'ucla-wordpress-plugin/motion-props', withMotionProps);
addFilter('editor.BlockListBlock', 'ucla-wordpress-plugin/blocklistblock-motion', withMotionBlockListBlock)