import { __ } from '@wordpress/i18n';

import {
	useRef,
	useState,
	useEffect,
	Platform,
} from '@wordpress/element'

import {
	Panel,
	PanelBody,
	__experimentalToggleGroupControl as ToggleGroupControl,
  	__experimentalToggleGroupControlOption as ToggleGroupControlOption,
} from '@wordpress/components'

import {
	more
} from '@wordpress/icons'

import {
	useDispatch,
} from '@wordpress/data'

import {
	store as noticesStore,
} from '@wordpress/notices'

import {
	displayShortcut
} from '@wordpress/keycodes'

import InspectorControlsLocation from './inspector-controls-location';

const InspectorControls = ({clientId, attributes, setAttributes}) => {
	const {motionForBlocks = {}} = attributes;
	const onTriggerChange = value => {
		setAttributes({
			motionForBlocks: {
				trigger: value
			}
		})
	}
	let {animation, trigger} = motionForBlocks;
	const hasAnimation = !!(animation && animation !== 'none');
	return (
		<InspectorControlsLocation location='styles'>
			<Panel>
				<PanelBody title={__('Animation', 'ucla-wordpress-plugin')} initialOpen={false}>
					<ToggleGroupControl
						label="trigger"
						isBlock
						__nextHasNoMarginBottom
						__next40pxDefaultSize
						isDeselectable
						onChange={value => onTriggerChange(value)}
					>
						<ToggleGroupControlOption value="pageload" label="Page Load" />
						<ToggleGroupControlOption value="inview" label="In View" />
					</ToggleGroupControl>
				</PanelBody>
			</Panel>
		</InspectorControlsLocation>
	)
}

export default InspectorControls;