import { useRef, useEffect } from "@wordpress/element";
//import { motion } from "motion/react";
import gsap from 'gsap';
import { useGSAP } from '@gsap/react';

// const AnimatedBlockListBlock = (props) => {
//   const {BlockListBlock, ...blockListBlockProps} = props;
//   const {
// 		clientId,
// 		attributes,
// 		wrapperProps = {},
// 	} = blockListBlockProps;
//   const {
// 		motionForBlocks = {},
// 	} = attributes;
//   // const iframe = document.getElementsByName('editor-canvas')[0];
//   // const innerDoc = (iframe.contentDocument) ? iframe.contentDocument : iframe.contentWindow.document;
//   // let blockRef = useRef();

//   // useEffect(()=>{
//   //   let el = innerDoc.getElementById(`block-${clientId}`);
//   //   blockRef.current = el;
//   // }, [clientId])
//   return (
//     // <motion.div
//     // animate={{ scale: 2 }}
//     // whileInView={{ opacity: 1 }}
//     // style={{ x: 100 }}
//     // >
//     // <BlockListBlock
//     //   {...blockListBlockProps}
//     //   wrapperProps={{
//     //     ...wrapperProps
//     //   }}
//     // />
//     // </motion.div>
//     <BlockListBlock
//       {...blockListBlockProps}
//       wrapperProps={{
//         ...wrapperProps
//       }}
//     />
//   )
// }


// const Component = forwardRef((props, ref) => {
//   const {BlockListBlock, ...blockListBlockProps} = props;
//   const {
// 		clientId,
// 		attributes,
// 		wrapperProps = {},
// 	} = blockListBlockProps;
//   const {
// 		motionForBlocks = {},
// 	} = attributes;
// const iframe = document.getElementsByName('editor-canvas')[0];
//   const innerDoc = (iframe.contentDocument) ? iframe.contentDocument : iframe.contentWindow.document;
//   ref = useRef();
//   useEffect(()=>{
//     let el = innerDoc.getElementById(`block-${clientId}`);
//     ref.current = el;
//   }, [clientId])
//   console.log(wrapperProps);

//   return (
//     <BlockListBlock
//       {...blockListBlockProps}
//       wrapperProps={{
//         ...wrapperProps,
//       }}
//     />
//   )
// })

// const AnimatedBlockListBlock = motion.create(Component, { forwardMotionProps: true })

const AnimatedBlockListBlock = (props) => {
  const {BlockListBlock, ...blockListBlockProps} = props;
  const {
		clientId,
		attributes,
		wrapperProps = {},
	} = blockListBlockProps;
  const {
		motionForBlocks = {},
	} = attributes;
  const iframe = document.getElementsByName('editor-canvas')[0];
  const innerDoc = (iframe.contentDocument) ? iframe.contentDocument : iframe.contentWindow.document;
  let blockRef = useRef();
  gsap.registerPlugin(useGSAP);
  
  useEffect(()=>{
    let el = innerDoc.getElementById(`block-${clientId}`);
    blockRef.current = el;
  }, [clientId])

  useGSAP(
    () => {
        const block = innerDoc.getElementById(`block-${clientId}`)
        // gsap code here...
        // gsap.set(block, { opacity: 0 })
        // gsap.to(block, { x: 360, opacity: 1, duration: 5 });
    },
    { scope: innerDoc }
  )
  
  return (
    <BlockListBlock
      {...blockListBlockProps}
      wrapperProps={{
        ...wrapperProps
      }}
    />
  )
}

export default AnimatedBlockListBlock;