/**
 * Retrieves the translation of text.
 *
 * @see https://developer.wordpress.org/block-editor/packages/packages-i18n/
 */
import "./style.scss";

import { useBlockProps, RichText } from "@wordpress/block-editor";
/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/developers/block-api/block-edit-save/#save
 * @param {Object} [props]           Properties passed from the editor.
 * @param {Object} props.attributes
 * @param {string} props.attributes.title
 * @param {string} props.attributes.url
 * @param {string} props.attributes.linkTarget
 * @param {string} props.attributes.greyStyle
 * @param {string} props.attributes.rel
 * @param {string} props.className
 * @return {WPElement} Element to render.
 */
const Save = ({ attributes }) => {
  let {
    tileHeadingLevel,
    tileTitle,
    tileBody,
    tileUrl,
    tileUrlTarget,
    tileUrlRel,
  } = attributes;
  const blockProps = useBlockProps.save();
  const TagName = "h" + tileHeadingLevel;
  const AnchorWrapper = ({ condition, wrapper, children }) =>
    condition ? wrapper(children) : <div className="ucla-tile">{children}</div>;

  return (
    <div {...blockProps}>
      <AnchorWrapper
        condition={tileUrl}
        wrapper={(children) => (
          <a
            className="ucla-tile"
            href={tileUrl}
            target={tileUrlTarget}
            rel={tileUrlRel}
          >
            {children}
          </a>
        )}
      >
        <RichText.Content
          value={tileTitle}
          tagName={TagName}
          className="ucla-tile__title"
        />
        <RichText.Content
          value={tileBody}
          tagName="p"
          className="ucla-tile__text"
        />
      </AnchorWrapper>
    </div>
  );
};
export default Save;
