import { useBlockProps, InnerBlocks } from "@wordpress/block-editor";
const Save = ({ attributes }) => {
  const blockProps = useBlockProps.save();
  let {tabValues} = attributes;
  return (
    <div {...blockProps}>
      <div className="ucla-tabs">
        <nav className="ucla-tabslist" role="tablist">
          {tabValues && tabValues.map(({clientId, tabLabel}, index) => {
          let formatTabLabel = tabLabel.replace(/\s+/g, '-').toLowerCase();
          return (
              <button
                key={clientId}
                className={`ucla-tablink${index === 0 ? ' is-active' : ''}`}
                role="tab"
                aria-selected={index === 0}
              >{tabLabel}</button>
          )})}
        </nav>
        <section className="ucla-tabpanels">
          <InnerBlocks.Content /> 
        </section>
      </div>
    </div>
  );
}
export default Save;