import {
  InnerBlocks,
  useBlockProps
} from "@wordpress/block-editor";
const Save = ({attributes: {blockId, innerblockIndex, tabLabel}}) => {
  const blockProps = useBlockProps.save({className: 'ucla-tabpanel'});
  let formatTabLabel = tabLabel.replace(/\s+/g, '-').toLowerCase();
  return (
    <article
      tabIndex={0}
      role="tabpanel"
      {...blockProps}
      hidden={innerblockIndex!==0}
    ><InnerBlocks.Content /></article>
  );
}
export default Save;