/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { useBlockProps } from "@wordpress/block-editor";

import { RichText } from "@wordpress/block-editor";

import "./style.scss";

const Save = ({ attributes }) => {
  const { ribbonVariant, ribbonContent, ribbonWidth } = attributes;
  
  const blockProps = useBlockProps.save();
  return (
    <div {...blockProps}>
      <div style={{maxWidth: ribbonWidth ? ribbonWidth : null}} className={`ucla-ribbon ucla-ribbon--${ribbonVariant}`}>
      <RichText.Content
        className="ucla-ribbon__text"
        tagName={ribbonVariant === "brand" ? "h2" : "h3"}
        value={ribbonContent}
      />
      </div>
    </div>
  );
};
export default Save;
