import { __ } from "@wordpress/i18n";
/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import {
  useBlockProps,
  InspectorControls,
  RichText,
} from "@wordpress/block-editor";
import { PanelBody, SelectControl, __experimentalUnitControl as UnitControl } from "@wordpress/components";

const Edit = ({ attributes, setAttributes }) => {
  let { ribbonVariant, ribbonContent, ribbonWidth } = attributes;
  const blockProps = useBlockProps();
  const onVariantChange = (variant) => {
    setAttributes({ ribbonVariant: variant });
  };
  const onWidthChange = (width) => {
    setAttributes({ribbonWidth: width})
  }
  return (
    <>
      <InspectorControls>
        <PanelBody title={__("Settings", "ucla-wordpress-plugin")} initialOpen>
          <SelectControl
            __next40pxDefaultSize
            __nextHasNoMarginBottom
            label={__("Select variant", "ucla-wordpress-plugin")}
            value={ribbonVariant}
            onChange={onVariantChange}
            help={__(
              "Change the variant of the ribbon.",
              "ucla-wordpress-plugin"
            )}
            options={[
              {
                value: "brand",
                label: __("Brand", "ucla-wordpess-plugin"),
              },
              {
                value: "highlight",
                label: __("Highlight", "ucla-wordpess-plugin"),
              },
            ]}
          />
          <UnitControl
             __next40pxDefaultSize
             label={__("Ribbon Width", "ucla-wordpress-plugin")}
             onChange={onWidthChange}
             value={ribbonWidth}
             help={__(
              "Change the width of the ribbon",
              "ucla-wordpress-plugin"
             )}
          />
        </PanelBody>
      </InspectorControls>
      <div {...blockProps}>
        <div style={{maxWidth: ribbonWidth}} className={`ucla-ribbon ucla-ribbon--${ribbonVariant}`}>
          <RichText
            className="ucla-ribbon__text"
            tagName={ribbonVariant === "brand" ? "h2" : "h3"}
            onChange={(content) => {
              setAttributes({ ribbonContent: content });
            }}
            value={ribbonContent}
            placeholder="Lorem ipsum dolor sit amet consectetuer adipiscing"
            preserveWhiteSpace={false}
          />
        </div>
      </div>
    </>
  );
};
export default Edit;
