import { __ } from "@wordpress/i18n";
import { PanelBody, PanelRow, Button, __experimentalGrid as Grid, ColorPalette, RangeControl } from "@wordpress/components";
import { useState } from "@wordpress/element";
import { InspectorControls, useBlockProps, useSettings } from "@wordpress/block-editor";
import {
  Icon,
  menu,
  close,
  search,
  chevronUp,
  chevronDown,
  chevronLeft,
  chevronRight,
  chevronsLeft,
  chevronsRight,
  arrowUp,
  arrowDown,
  arrowRight,
  arrowLeft,
  chat,
  comment,
  envelope,
  location,
  userCircle,
  user,
  videoCamera,
  check,
  closeCircle,
  copy,
  download,
  imageGallery,
  image,
  linkExternal,
  minus,
  pauseCircle,
  playCircle,
  plus,
  sort,
  sunny,
  cloudy,
  partlyCloudy,
  fog,
  windy,
  rain,
  thunderstorm,
  moon,
  fullMoon,
  calendar,
  clock,
  error,
  information,
  success,
  warning,
} from "../../assets/icon-library";
const Edit = ({ attributes, setAttributes }) => {
  let { icon, iconColor, size } = attributes;
  const [color, setColor] = useState(iconColor);
  const [iconSize, setIconSize] = useState(size);
  const [colors] = useSettings('color.palette') || [];
  const blockProps = useBlockProps();
  const onColorChange = (color) => {
    setAttributes({iconColor: color})
    setColor(color)
  }
  const onSizeChange = (value) => {
    setAttributes({size: value})
    setIconSize(value)
  }
  const iconSelectOption = [
    {
      label: __("Menu", "ucla-wordpress-plugin"),
      value: "menu",
      icon: menu,
    },
    {
      label: __("Close", "ucla-wordpress-plugin"),
      value: "close",
      icon: close,
    },
    {
      label: __("Close Circle", "ucla-wordpress-plugin"),
      value: "closeCircle",
      icon: closeCircle
    },
    {
      label: __("Search", "ucla-wordpress-plugin"),
      value: "search",
      icon: search
    },
    {
      label: __("Chevron Up", "ucla-wordpress-plugin"),
      value: "chevronUp",
      icon: chevronUp
    },
    {
      label: __("Chevron Down", "ucla-wordpress-plugin"),
      value: "chevronDown",
      icon: chevronDown
    },
    {
      label: __("Chevron Left", "ucla-wordpress-plugin"),
      value: "chevronLeft",
      icon: chevronLeft
    },
    {
      label: __("Chevron Right", "ucla-wordpress-plugin"),
      value: "chevronRight",
      icon: chevronRight
    },
    {
      label: __("Double Chevron Left", "ucla-wordpress-plugin"),
      value: "chevronsLeft",
      icon: chevronsLeft
    },
    {
      label: __("Double Chevron Right", "ucla-wordpress-plugin"),
      value: "chevronsRight",
      icon: chevronsRight
    },
    {
      label: __("Arrow Up", "ucla-wordpress-plugin"),
      value: "arrowUp",
      icon: arrowUp
    },
    {
      label: __("Arrow Down", "ucla-wordpress-plugin"),
      value: "arrowDown",
      icon: arrowDown
    },
    {
      label: __("Arrow Left", "ucla-wordpress-plugin"),
      value: "arrowLeft",
      icon: arrowLeft
    },
    {
      label: __("Arrow Right", "ucla-wordpress-plugin"),
      value: "arrowRight",
      icon: arrowRight
    },
    {
      label: __("Chat", "ucla-wordpress-plugin"),
      value: "chat",
      icon: chat
    },
    {
      label: __("Comment", "ucla-wordpress-plugin"),
      value: "comment",
      icon: comment
    },
    {
      label: __("Envelope", "ucla-wordpress-plugin"),
      value: "envelope",
      icon: envelope
    },
    {
      label: __("Location", "ucla-wordpress-plugin"),
      value: "location",
      icon: location
    },
    {
      label: __("User Circle", "ucla-wordpress-plugin"),
      value: "userCircle",
      icon: userCircle
    },
    {
      label: __("User", "ucla-wordpress-plugin"),
      value: "user",
      icon: user
    },
    {
      label: __("Video Camera", "ucla-wordpress-plugin"),
      value: "videoCamera",
      icon: videoCamera
    },
    {
      label: __("Check", "ucla-wordpress-plugin"),
      value: "check",
      icon: check
    },
    {
      label: __("Copy", "ucla-wordpress-plugin"),
      value: "copy",
      icon: copy
    },
    {
      label: __("Download", "ucla-wordpress-plugin"),
      value: "download",
      icon: download
    },
    {
      label: __("Image", "ucla-wordpress-plugin"),
      value: "image",
      icon: image
    },
    {
      label: __("Image Gallery", "ucla-wordpress-plugin"),
      value: "imageGallery",
      icon: imageGallery
    },
    {
      label: __("External Link", "ucla-wordpress-plugin"),
      value: "linkExternal",
      icon: linkExternal
    },
    {
      label: __("Minus", "ucla-wordpress-plugin"),
      value: "minus",
      icon: minus
    },
    {
      label: __("Plus", "ucla-wordpress-plugin"),
      value: "plus",
      icon: plus
    },
    {
      label: __("Pause Circle", "ucla-wordpress-plugin"),
      value: "pauseCircle",
      icon: pauseCircle
    },
    {
      label: __("Play Circle", "ucla-wordpress-plugin"),
      value: "playCircle",
      icon: playCircle
    },
    {
      label: __("Sort", "ucla-wordpress-plugin"),
      value: "sort",
      icon: sort
    },
    {
      label: __("Sunny", "ucla-wordpress-plugin"),
      value: "sunny",
      icon: sunny
    },
    {
      label: __("Cloudy", "ucla-wordpress-plugin"),
      value: "cloudy",
      icon: cloudy
    },
    {
      label: __("Partly Cloudy", "ucla-wordpress-plugin"),
      value: "partlyCloudy",
      icon: partlyCloudy
    },
    {
      label: __("Fog", "ucla-wordpress-plugin"),
      value: "fog",
      icon: fog
    },
    {
      label: __("Windy", "ucla-wordpress-plugin"),
      value: "windy",
      icon: windy
    },
    {
      label: __("Rain", "ucla-wordpress-plugin"),
      value: "rain",
      icon: rain
    },
    {
      label: __("Thunderstorm", "ucla-wordpress-plugin"),
      value: "thunderstorm",
      icon: thunderstorm
    },
    {
      label: __("Moon", "ucla-wordpress-plugin"),
      value: "moon",
      icon: moon
    },
    {
      label: __("Full Moon", "ucla-wordpress-plugin"),
      value: "fullMoon",
      icon: fullMoon
    },
    {
      label: __("Calendar", "ucla-wordpress-plugin"),
      value: "calendar",
      icon: calendar
    },
    {
      label: __("Clock", "ucla-wordpress-plugin"),
      value: "clock",
      icon: clock
    },
    {
      label: __("Error", "ucla-wordpress-plugin"),
      value: "error",
      icon: error
    },
    {
      label: __("Information", "ucla-wordpress-plugin"),
      value: "information",
      icon: information
    },
    {
      label: __("Success", "ucla-wordpress-plugin"),
      value: "success",
      icon: success
    },
    {
      label: __("Warning", "ucla-wordpress-plugin"),
      value: "warning",
      icon: warning
    },
  ];
  let iconObj = {
    menu,
    close,
    search,
    chevronUp,
    chevronDown,
    chevronLeft,
    chevronRight,
    chevronsLeft,
    chevronsRight,
    arrowUp,
    arrowDown,
    arrowRight,
    arrowLeft,
    chat,
    comment,
    envelope,
    location,
    userCircle,
    user,
    videoCamera,
    check,
    closeCircle,
    copy,
    download,
    imageGallery,
    image,
    linkExternal,
    minus,
    pauseCircle,
    playCircle,
    plus,
    sort,
    sunny,
    cloudy,
    partlyCloudy,
    fog,
    windy,
    rain,
    thunderstorm,
    moon,
    fullMoon,
    calendar,
    clock,
    error,
    information,
    success,
    warning,
  };
  return (
    <>
      <InspectorControls>
        <PanelBody className="icon-picker" title={__("Icon Selection", "ucla-wordpress-plugin")}>
          <PanelRow>
            <Grid
              className="icon-picker__grid"
              columns="5"
              gap="0"
            >
              {iconSelectOption.map((iconSelectIcon, index) => {
              return (
                <Button
                  key={index}
                  label={iconSelectIcon?.label}
                  isPressed={icon === iconSelectIcon.value}
                  className="icon-picker__button"
                  onClick={() => {
                    setAttributes({
                      icon: iconSelectIcon.value
                    })
                  }}
                >
                  <Icon color="#000000" icon={iconSelectIcon.icon} />
                </Button>
              )})}
            </Grid>
          </PanelRow>
        </PanelBody>
        <PanelBody title={__("Size (in pixels)", "ucla-wordpress-plugin")}>
            <RangeControl
              __nextHasNoMarginBottom
              min={24}
              max={144}
              onChange={(value)=>onSizeChange(value)}
              value={iconSize}
              initialPosition={24}
              step={4}
              allowReset={true}
            />
        </PanelBody>
        <PanelBody title={__("Color", "ucla-wordpress-plugin")}>
          <ColorPalette
              onChange={(color)=>onColorChange(color)}
              colors={colors}
              value={color}
          />
        </PanelBody>
      </InspectorControls>
      <div {...blockProps}>{icon && <Icon size={iconSize} color={iconColor} icon={iconObj[icon]} />}</div>
    </>
  );
};

export default Edit;
