import { useBlockProps, useInnerBlocksProps } from "@wordpress/block-editor";

const Save = ({ attributes }) => {
  let { perPage, perPageTablet, perPageMobile, perGroup, perGroupTablet, perGroupMobile, ariaLabel, showPagination, showNavigation, enableLoop, enableAutoPlay, autoPlayDelay, carouselGap } = attributes;
  const blockProps = useBlockProps.save({
    className: 'swiper ucla-carousel',
  });
  const innerBlocksProps = useInnerBlocksProps.save(blockProps)
  return (
      <div
        {...blockProps}
        data-ucla-carousel-autoplay={enableAutoPlay}
        data-ucla-carousel-autoplay-delay={autoPlayDelay ? autoPlayDelay : null}
        data-swiper={`
          {"slidesPerGroup": ${perGroupMobile ? perGroupMobile : perGroup},
          "slidesPerView": ${perPageMobile ? perPageMobile : perPage},
          "loop": ${enableLoop},
          "resizeObserver": false,
          "loopAddBlankSlides": false,
          "spaceBetween": ${carouselGap},
          "breakpoints": {
            "768": {
              "slidesPerGroup": ${perGroupTablet ? perGroupTablet : perGroup},
              "slidesPerView": ${perPageTablet ? perPageTablet : perPage}
            },
            "960": {
             "slidesPerGroup": ${perGroup},
             "slidesPerView": ${perPage}
            }
            }
          }
        `}
        aria-label={ariaLabel}
      >
        <div className="swiper-wrapper">
            {innerBlocksProps.children}
        </div>
        {showPagination &&
          <div className="swiper-pagination ucla-carousel__pagination"></div>
        }
        {showNavigation &&
          <>
            <div className="swiper-button-prev ucla-carousel__prev"></div>
            <div className="swiper-button-next ucla-carousel__next"></div>
          </>
        }
      </div>
  );
};
export default Save;
