import { InnerBlocks, useBlockProps } from "@wordpress/block-editor";
import './style.scss';
const Save = ({ attributes }) => {
  let {mediaAlt,mediaId,mediaUrl,cardVariant,cardContentPadding} = attributes;
  const blockProps = useBlockProps.save();
  return (
    <div {...blockProps}>
      <article className={`ucla-card${cardVariant === 'info' ? " ucla-card__info" : ""}`}>
        {cardVariant === "default" && mediaId &&
          <img src={mediaUrl} alt={mediaAlt && mediaAlt} className={`ucla-card__image wp-image-${mediaId}`} />
        }
        <div
          className="ucla-card__body"
          style={cardContentPadding && {
            "paddingTop": cardContentPadding.top,
            "paddingBottom": cardContentPadding.bottom,
            "paddingLeft": cardContentPadding.left,
            "paddingRight": cardContentPadding.right,
          }}
        >
          <InnerBlocks.Content />
        </div>
      </article>
    </div>
  );
}
export default Save;