import { InnerBlocks, useBlockProps } from "@wordpress/block-editor";
import "./style.scss";
const Save = ({ attributes }) => {
  let { cardVariant, cardBackground, mediaId, mediaUrl, mediaAlt, url, linkTarget, rel, cardDate, imagePosition, cardContentPadding } =
    attributes;
  let colorName = (color) => {
    switch (color) {
      case "#f2f2f2":
        return (
          "grey-05"
        );
        break;
      case "#ffd100":
        return (
          "ucla-gold"
        );
        break;
      case "#8bb8e8":
        return (
          "info"
        );
        break;
      case "#2774ae":
        return (
          "ucla-blue"
        );
        break;
      default:
        return;
    }
  };
  const blockProps = useBlockProps.save();
;  return (
    <div {...blockProps} className={`${cardVariant === 'secondary' ? `${blockProps.className} wp-block-ucla-wordpress-plugin-card-story-secondary` : blockProps.className}`}>
      <article
        className={`ucla-card ucla-card__story${
          cardVariant !== "default" ? `-${cardVariant}${imagePosition ? " ucla-card__story-left" : ""}` : ""
        }`}
      >
        {mediaId && (
          <>
            {url ? (
              <a
                className="story-card-image-link"
                href={url}
                target={linkTarget && linkTarget}
                rel={rel && rel}
              >
                <img
                  src={mediaUrl}
                  alt={mediaAlt && mediaAlt}
                  className={`ucla-card__${
                    cardVariant === "featured" ? "story-featured-" : ""
                  }image wp-image-${mediaId}`}
                />
              </a>
            ) : (
              <div className="story-card-image-link">
              <img
                src={mediaUrl}
                alt={mediaAlt && mediaAlt}
                className={`ucla-card__${
                  cardVariant === "featured" ? "story-featured-" : ""
                }image wp-image-${mediaId}`}
              />
              </div>
            )}
          </>
        )}
        <div
          className={`ucla-card__${cardVariant === "featured" ? "story-featured-" : ""}body${cardBackground? ` ucla-has-background-${colorName(cardBackground)}` : ''}`}
          style={cardContentPadding && {
            "paddingTop": cardContentPadding.top,
            "paddingBottom": cardContentPadding.bottom,
            "paddingLeft": cardContentPadding.left,
            "paddingRight": cardContentPadding.right,
          }}
        >
            {cardDate &&
              <p className="ucla-card__date">
              {new Date(cardDate).toLocaleDateString("en-US", {
                year: "numeric",
                month: "long",
                day: "numeric",
              })}
            </p>
            }
            <InnerBlocks.Content />
        </div>
      </article>
    </div>
  );
};
export default Save;
