import { InnerBlocks, useBlockProps } from "@wordpress/block-editor";
import './style.scss';
const Save = ({ attributes }) => {
  let { mediaId, mediaUrl, mediaAlt, url, linkTarget, rel } =
  attributes;
  const blockProps = useBlockProps.save();
  return (
    <div  {...blockProps}>
      <article className="ucla-card ucla-card__person">
          {url ? (
            <a
              className="ucla-card__image-link"
              href={url}
              target={linkTarget && linkTarget}
              rel={rel && rel}
            >
              <img
                src={mediaId ? mediaUrl : "https://2.gravatar.com/avatar/e609dd760d28d3325cd011c02fba434a?s=192&d=mm&r=g"}
                alt={mediaAlt && mediaAlt}
                className={`ucla-card__image wp-image-${mediaId}`}
              />
            </a>
          ) : (
            <div className="ucla-card__image-link">
              <img
                src={mediaId ? mediaUrl : "https://2.gravatar.com/avatar/e609dd760d28d3325cd011c02fba434a?s=192&d=mm&r=g"}
                alt={mediaAlt && mediaAlt}
                className={`ucla-card__image wp-image-${mediaId}`}
              />
            </div>
          )}
          <div className="ucla-card__body">
            <InnerBlocks.Content />
          </div>
      </article>
    </div>  
  );
}
export default Save;