import { useBlockProps, RichText } from "@wordpress/block-editor";
const Save = ({ attributes }) => {
  let { calloutBody, calloutVariant, calloutNumber, calloutCitation } =
    attributes;
  const blockProps = useBlockProps.save();
  const BodyWrapper = ({ condition, wrapper, children }) =>
    condition ? wrapper(children) : children;
  return (
    <div {...blockProps}>
      <aside
        class={`ucla-callout${
          calloutVariant !== "default" ? ` ucla-callout__${calloutVariant}` : ""
        }`}
      >
        {calloutVariant !== "default" && (
          <RichText.Content
            tagName="span"
            value={calloutNumber}
            className="ucla-callout__number"
            preserveWhiteSpace={true}
          />
        )}
        <BodyWrapper
          condition={calloutVariant !== "default"}
          wrapper={(children) => (
            <div className="ucla-callout__body">{children}</div>
          )}
        >
          <RichText.Content value={calloutBody} preserveWhiteSpace={true} />
          {calloutVariant === "ranking" && (
            <RichText.Content
              tagName="cite"
              value={calloutCitation}
              preserveWhiteSpace={true}
            />
          )}
        </BodyWrapper>
      </aside>
    </div>
  );
};
export default Save;
