import { __ } from "@wordpress/i18n";
import {
  useBlockProps,
  RichText,
  InspectorControls,
} from "@wordpress/block-editor";
import { PanelBody, SelectControl } from "@wordpress/components";
const Edit = ({ attributes, setAttributes }) => {
  let { calloutBody, calloutNumber, calloutVariant, calloutCitation } =
    attributes;
  const blockProps = useBlockProps();
  const onVariantChange = (variant) => {
    setAttributes({ calloutVariant: variant });
  };
  return (
    <>
      <InspectorControls>
        <PanelBody title={__("Settings", "ucla-wordpress-plugin")} initialOpen>
          <SelectControl
            label={__("Select variant", "ucla-wordpress-plugin")}
            value={calloutVariant}
            onChange={onVariantChange}
            help={__(
              "Change the variant of the callout.",
              "ucla-wordpress-plugin"
            )}
            options={[
              {
                value: "default",
                label: __("Factoid", "ucla-wordpess-plugin"),
              },
              {
                value: "ranking",
                label: __("Ranking", "ucla-wordpess-plugin"),
              },
              {
                value: "statistics",
                label: __("Statistic", "ucla-wordpess-plugin"),
              },
            ]}
          />
        </PanelBody>
      </InspectorControls>
      <div {...blockProps}>
        <aside
          className={`ucla-callout${
            calloutVariant !== "default"
              ? ` ucla-callout__${calloutVariant}`
              : ""
          }`}
        >
          {calloutVariant !== "default" && (
            <RichText
              value={calloutNumber}
              onChange={(content) => {
                setAttributes({ calloutNumber: content });
              }}
              tagName="span"
              placeholder={calloutVariant === "ranking" ? "#9" : "31,000"}
              className="ucla-callout__number"
              preserveWhiteSpace={false}
            />
          )}
          {calloutVariant !== "default" ? (
            <div className="ucla-callout__body">
              <RichText
                value={calloutBody}
                placeholder={
                  calloutVariant === "ranking"
                    ? "Lorem ipsum dolor sit amet"
                    : "Lorem ipsum dolor sit amet, consectetur adipiscing elit"
                }
                onChange={(content) => {
                  setAttributes({ calloutBody: content });
                }}
                preserveWhiteSpace={true}
                tagName="span"
              />
              {calloutVariant === "ranking" && (
                <RichText
                  value={calloutCitation}
                  placeholder={__("Lorem ipsum", "ucla-wordpress-plugin")}
                  onChange={(content) => {
                    setAttributes({ calloutCitation: content });
                  }}
                  preserveWhiteSpace={true}
                  tagName="cite"
                />
              )}
            </div>
          ) : (
            <RichText
              value={calloutBody}
              placeholder={__(
                "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.",
                "ucla-wordpress-plugin"
              )}
              onChange={(content) => {
                setAttributes({ calloutBody: content });
              }}
              preserveWhiteSpace={true}
              tagName="span"
            />
          )}
        </aside>
      </div>
    </>
  );
};
export default Edit;
