import classnames from "classnames/dedupe";
import { __ } from "@wordpress/i18n";
import { createHigherOrderComponent } from "@wordpress/compose";
import { InspectorControls } from "@wordpress/block-editor";
import { Button, PanelBody, PanelRow, SelectControl, __experimentalText as Text, __experimentalGrid as Grid } from "@wordpress/components";
import {
  Icon,
  menu,
  close,
  search,
  chevronUp,
  chevronDown,
  chevronLeft,
  chevronRight,
  chevronsLeft,
  chevronsRight,
  arrowUp,
  arrowDown,
  arrowRight,
  arrowLeft,
  chat,
  comment,
  envelope,
  location,
  userCircle,
  user,
  videoCamera,
  check,
  closeCircle,
  copy,
  download,
  imageGallery,
  image,
  linkExternal,
  minus,
  pauseCircle,
  playCircle,
  plus,
  sort,
  sunny,
  cloudy,
  partlyCloudy,
  fog,
  windy,
  rain,
  thunderstorm,
  moon,
  fullMoon,
  calendar,
  clock,
  error,
  information,
  success,
  warning,
} from "../../../assets/icon-library";

const enableSideBarOnBlocks = ["core/button"];

const setSidebarAttribute = (settings, name) => {
  if (!enableSideBarOnBlocks.includes(name)) {
    return settings;
  }
  return Object.assign({}, settings, {
    attributes: Object.assign({}, settings.attributes, {
      buttonIcon: { type: "string" },
      buttonIconAlign: { type: "string", default: "trail" },
    }),
  });
};
wp.hooks.addFilter(
  "blocks.registerBlockType",
  "ucla-wordpress-plugin/set-sidebar-attribute",
  setSidebarAttribute
);

const withSidebarSelect = createHigherOrderComponent((BlockEdit) => {
  return (props) => {
    // If current block is not allowed
    if (!enableSideBarOnBlocks.includes(props.name)) {
      return <BlockEdit {...props} />;
    }

    const { attributes, setAttributes } = props;
    const { buttonIcon, buttonIconAlign } = attributes;

    const iconSelectOption = [
      {
        label: __("Menu", "ucla-wordpress-plugin"),
        value: "menu",
        icon: menu,
      },
      {
        label: __("Close", "ucla-wordpress-plugin"),
        value: "close",
        icon: close,
      },
      {
        label: __("Close Circle", "ucla-wordpress-plugin"),
        value: "close-circle-solid",
        icon: closeCircle
      },
      {
        label: __("Search", "ucla-wordpress-plugin"),
        value: "search",
        icon: search
      },
      {
        label: __("Chevron Up", "ucla-wordpress-plugin"),
        value: "chevron-up",
        icon: chevronUp
      },
      {
        label: __("Chevron Down", "ucla-wordpress-plugin"),
        value: "chevron-down",
        icon: chevronDown
      },
      {
        label: __("Chevron Left", "ucla-wordpress-plugin"),
        value: "chevron-left",
        icon: chevronLeft
      },
      {
        label: __("Chevron Right", "ucla-wordpress-plugin"),
        value: "chevron-right",
        icon: chevronRight
      },
      {
        label: __("Double Chevron Left", "ucla-wordpress-plugin"),
        value: "chevrons-left",
        icon: chevronsLeft
      },
      {
        label: __("Double Chevron Right", "ucla-wordpress-plugin"),
        value: "chevrons-right",
        icon: chevronsRight
      },
      {
        label: __("Arrow Up", "ucla-wordpress-plugin"),
        value: "arrow-up",
        icon: arrowUp
      },
      {
        label: __("Arrow Down", "ucla-wordpress-plugin"),
        value: "arrow-down",
        icon: arrowDown
      },
      {
        label: __("Arrow Left", "ucla-wordpress-plugin"),
        value: "arrow-left",
        icon: arrowLeft
      },
      {
        label: __("Arrow Right", "ucla-wordpress-plugin"),
        value: "arrow-right",
        icon: arrowRight
      },
      {
        label: __("Chat", "ucla-wordpress-plugin"),
        value: "chat",
        icon: chat
      },
      {
        label: __("Comment", "ucla-wordpress-plugin"),
        value: "comment",
        icon: comment
      },
      {
        label: __("Envelope", "ucla-wordpress-plugin"),
        value: "envelope",
        icon: envelope
      },
      {
        label: __("Location", "ucla-wordpress-plugin"),
        value: "location",
        icon: location
      },
      {
        label: __("User Circle", "ucla-wordpress-plugin"),
        value: "user-circle",
        icon: userCircle
      },
      {
        label: __("User", "ucla-wordpress-plugin"),
        value: "user",
        icon: user
      },
      {
        label: __("Video Camera", "ucla-wordpress-plugin"),
        value: "video-camera",
        icon: videoCamera
      },
      {
        label: __("Facebook", "ucla-wordpress-plugin"),
        value: "facebook",
        icon: (
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g clipPath="url(#clip0_74_797)"><path d="M22 12.0611C22 6.50451 17.5229 2 12 2C6.47715 2 2 6.50451 2 12.0611C2 17.0828 5.65684 21.2452 10.4375 22V14.9694H7.89844V12.0611H10.4375V9.84452C10.4375 7.32296 11.9305 5.93012 14.2146 5.93012C15.3088 5.93012 16.4531 6.12663 16.4531 6.12663V8.60261H15.1922C13.95 8.60261 13.5625 9.37822 13.5625 10.1739V12.0611H16.3359L15.8926 14.9694H13.5625V22C18.3432 21.2452 22 17.083 22 12.0611Z" fill="#333333"/></g><defs><clipPath id="clip0_74_797"><rect width="20" height="20" fill="white" transform="translate(2 2)"/></clipPath></defs></svg>
        ),
      },
      {
        label: __("Instagram", "ucla-wordpress-plugin"),
        value: "instagram",
        icon: (
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M7.85848 2.06994C6.79447 2.12014 6.06786 2.28994 5.43265 2.53954C4.77524 2.79574 4.21804 3.13954 3.66363 3.69594C3.10923 4.25235 2.76782 4.80995 2.51342 5.46835C2.26722 6.10495 2.10042 6.83215 2.05342 7.89676C2.00642 8.96136 1.99601 9.30356 2.00121 12.0192C2.00641 14.7348 2.01841 15.0752 2.07001 16.142C2.12081 17.2058 2.29002 17.9322 2.53962 18.5676C2.79622 19.225 3.13962 19.782 3.69623 20.3366C4.25284 20.8912 4.81004 21.2318 5.47005 21.4866C6.10605 21.7324 6.83346 21.9 7.89787 21.9466C8.96228 21.9932 9.30489 22.004 12.0197 21.9988C14.7345 21.9936 15.0763 21.9816 16.143 21.931C17.2096 21.8804 17.9322 21.71 18.5678 21.4616C19.2252 21.2044 19.7826 20.8616 20.3368 20.3048C20.891 19.748 21.2322 19.19 21.4864 18.5312C21.7328 17.8952 21.9002 17.1678 21.9464 16.1042C21.993 15.0368 22.004 14.696 21.9988 11.9808C21.9936 9.26557 21.9814 8.92517 21.9308 7.85876C21.8802 6.79236 21.7108 6.06816 21.4614 5.43235C21.2044 4.77495 20.8614 4.21835 20.305 3.66335C19.7486 3.10834 19.1902 2.76734 18.5316 2.51374C17.8952 2.26754 17.1682 2.09974 16.1038 2.05374C15.0393 2.00774 14.6967 1.99594 11.9809 2.00114C9.26509 2.00634 8.92509 2.01794 7.85848 2.06994ZM7.97527 20.1476C7.00026 20.1052 6.47086 19.9432 6.11805 19.8076C5.65085 19.6276 5.31805 19.41 4.96644 19.0618C4.61484 18.7136 4.39884 18.3796 4.21644 17.9134C4.07943 17.5606 3.91443 17.0318 3.86883 16.0568C3.81923 15.003 3.80883 14.6866 3.80303 12.0168C3.79723 9.34696 3.80743 9.03096 3.85363 7.97676C3.89523 7.00256 4.05824 6.47255 4.19364 6.11995C4.37364 5.65215 4.59044 5.31995 4.93945 4.96855C5.28845 4.61715 5.62145 4.40075 6.08806 4.21835C6.44046 4.08075 6.96927 3.91715 7.94388 3.87075C8.99849 3.82075 9.31449 3.81075 11.9839 3.80495C14.6533 3.79915 14.9701 3.80915 16.0252 3.85555C16.9994 3.89795 17.5296 4.05935 17.8818 4.19555C18.3492 4.37555 18.6818 4.59175 19.0332 4.94135C19.3846 5.29095 19.6012 5.62275 19.7836 6.09036C19.9214 6.44176 20.085 6.97036 20.131 7.94556C20.1812 9.00017 20.1926 9.31637 20.1974 11.9856C20.2022 14.6548 20.1928 14.9718 20.1466 16.0256C20.104 17.0006 19.9424 17.5302 19.8066 17.8834C19.6266 18.3504 19.4096 18.6834 19.0604 19.0346C18.7112 19.3858 18.3786 19.6022 17.9118 19.7846C17.5598 19.922 17.0304 20.086 16.0566 20.1324C15.0019 20.182 14.6859 20.1924 12.0155 20.1982C9.34509 20.204 9.03008 20.1932 7.97547 20.1476M16.1276 6.65536C16.128 6.89271 16.1987 7.12462 16.3309 7.32175C16.4631 7.51887 16.6508 7.67237 16.8703 7.76282C17.0897 7.85326 17.3311 7.8766 17.5638 7.82988C17.7965 7.78316 18.0101 7.66847 18.1777 7.50033C18.3452 7.33219 18.4591 7.11814 18.505 6.88526C18.5508 6.65238 18.5266 6.41112 18.4354 6.19201C18.3441 5.9729 18.1899 5.78577 17.9923 5.65428C17.7947 5.5228 17.5625 5.45288 17.3252 5.45335C17.007 5.45399 16.7021 5.58097 16.4775 5.80638C16.2529 6.03179 16.127 6.33716 16.1276 6.65536ZM6.86546 12.01C6.87106 14.846 9.17429 17.1398 12.0097 17.1344C14.8451 17.129 17.1406 14.826 17.1352 11.99C17.1298 9.15397 14.8259 6.85956 11.9901 6.86516C9.15429 6.87076 6.86006 9.17436 6.86546 12.01ZM8.66668 12.0064C8.66538 11.3471 8.85961 10.7022 9.2248 10.1533C9.59 9.60442 10.1098 9.17614 10.7184 8.92264C11.327 8.66914 11.9971 8.6018 12.644 8.72914C13.2908 8.85648 13.8854 9.17278 14.3525 9.63804C14.8196 10.1033 15.1383 10.6966 15.2682 11.343C15.3981 11.9894 15.3334 12.6597 15.0823 13.2693C14.8312 13.8789 14.405 14.4004 13.8576 14.7677C13.3101 15.1351 12.666 15.3319 12.0067 15.3332C11.5689 15.3341 11.1353 15.2488 10.7305 15.0821C10.3257 14.9154 9.95773 14.6706 9.64757 14.3616C9.33741 14.0527 9.09114 13.6857 8.92284 13.2816C8.75454 12.8775 8.6675 12.4441 8.66668 12.0064Z" fill="#333333"/>
          </svg>
        )
      },
      {
        label: __("LinkedIn", "ucla-wordpress-plugin"),
        value: "linkedin",
        icon: (
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clipPath="url(#clip0_74_800)">
              <path d="M20.5236 2L3.47639 2C2.66111 2 2 2.66111 2 3.47639L2 20.5236C2 21.3389 2.66111 22 3.47639 22L20.5236 22C21.3389 22 22 21.3389 22 20.5236L22 3.47639C22 2.66111 21.3389 2 20.5236 2ZM7.96111 19.0389L4.95416 19.0389L4.95417 9.48611L7.96111 9.48611L7.96111 19.0389ZM6.45833 8.16389C5.50139 8.16389 4.725 7.43472 4.725 6.4375C4.725 5.44028 5.50139 4.71111 6.45833 4.71111C7.41528 4.71111 8.19167 5.44028 8.19167 6.4375C8.19167 7.43472 7.41528 8.16389 6.45833 8.16389ZM19.0458 19.0458L16.0389 19.0458L16.0389 13.8292C16.0389 12.2903 15.3847 11.8153 14.5403 11.8153C13.6486 11.8153 12.7736 12.4861 12.7736 13.8681L12.7736 19.0472L9.76666 19.0472L9.76667 9.49306L12.6583 9.49306L12.6583 10.8167L12.6972 10.8167C12.9875 10.2292 14.0042 9.225 15.5556 9.225C17.2333 9.225 19.0458 10.2208 19.0458 13.1375L19.0458 19.0458Z" fill="#333333"/>
            </g>
            <defs>
              <clipPath id="clip0_74_800">
                <rect width="20" height="20" fill="white" transform="translate(2 2)"/>
              </clipPath>
            </defs>
          </svg>
        )
      },
      {
        label: __("TikTok", "ucla-wordpress-plugin"),
        value: "tiktok",
        icon: (
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clipPath="url(#clip0_74_801)">
              <path d="M18.4609 5.80844C17.4108 5.14097 16.6528 4.07347 16.4165 2.82894C16.3654 2.55993 16.3374 2.2833 16.3374 2L12.9858 2L12.9803 15.0911C12.9239 16.5571 11.6861 17.7337 10.1684 17.7337C9.69672 17.7337 9.25242 17.6189 8.86151 17.4181C7.96479 16.9581 7.35124 16.0419 7.35124 14.9877C7.35124 13.4735 8.61512 12.2417 10.1684 12.2417C10.4584 12.2417 10.7363 12.2883 10.9997 12.3686L10.9997 9.0338C10.7272 8.99763 10.4506 8.97511 10.1684 8.97511C6.76731 8.97542 4 11.6726 4 14.9877C4 17.0218 5.04287 18.8218 6.63353 19.9103C7.63539 20.5958 8.85435 21 10.1687 21C13.57 21 16.3374 18.3028 16.3374 14.9877L16.3374 8.34951C17.6517 9.26919 19.2622 9.81103 21 9.81103L21 6.54443C20.0639 6.54443 19.1919 6.27319 18.4609 5.80844Z" fill="#333333"/>
            </g>
            <defs>
              <clipPath id="clip0_74_801">
                <rect width="17" height="19" fill="white" transform="translate(4 2)"/>
              </clipPath>
            </defs>
          </svg>
        )
      },
      {
        label: __("Twitter/X", "ucla-wordpress-plugin"),
        value: "twitter",
        icon: (
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M13.7124 10.6218L20.4133 3H18.8254L13.0071 9.61788L8.35992 3H3L10.0274 13.0074L3 21H4.58799L10.7324 14.0113L15.6401 21H21L13.7121 10.6218H13.7124ZM11.5375 13.0956L10.8255 12.0991L5.16017 4.16971H7.59922L12.1712 10.5689L12.8832 11.5655L18.8262 19.8835H16.3871L11.5375 13.096V13.0956Z" fill="#333333"/>
          </svg>
        )
      },
      {
        label: __("YouTube", "ucla-wordpress-plugin"),
        value: "youtube",
        icon: (
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fillRule="evenodd" clipRule="evenodd" d="M19.8136 4.44758C20.6739 4.69436 21.3523 5.42016 21.5818 6.34194C22 8.01371 22 11.5 22 11.5C22 11.5 22 14.9875 21.5818 16.6581C21.3523 17.5798 20.6739 18.3056 19.8136 18.5524C18.2545 19 12 19 12 19C12 19 5.74659 19 4.18636 18.5524C3.32614 18.3056 2.64773 17.5798 2.41818 16.6581C2 14.9863 2 11.5 2 11.5C2 11.5 2 8.01371 2.41818 6.34193C2.64773 5.42016 3.32614 4.69435 4.18637 4.44758C5.74546 4 12 4 12 4C12 4 18.2545 4 19.8136 4.44758ZM15.1818 11.5L9.95454 14.6657L9.95455 8.33427L15.1818 11.5Z" fill="#333333"/>
          </svg>
        )
      },
      {
        label: __("Check", "ucla-wordpress-plugin"),
        value: "check",
        icon: check
      },
      {
        label: __("Copy", "ucla-wordpress-plugin"),
        value: "copy",
        icon: copy
      },
      {
        label: __("Download", "ucla-wordpress-plugin"),
        value: "download",
        icon: download
      },
      {
        label: __("Image", "ucla-wordpress-plugin"),
        value: "image",
        icon: image
      },
      {
        label: __("Image Gallery", "ucla-wordpress-plugin"),
        value: "image-gallery",
        icon: imageGallery
      },
      {
        label: __("External Link", "ucla-wordpress-plugin"),
        value: "link-external",
        icon: linkExternal
      },
      {
        label: __("Minus", "ucla-wordpress-plugin"),
        value: "minus",
        icon: minus
      },
      {
        label: __("Plus", "ucla-wordpress-plugin"),
        value: "plus",
        icon: plus
      },
      {
        label: __("Pause Circle", "ucla-wordpress-plugin"),
        value: "pause-circle",
        icon: pauseCircle
      },
      {
        label: __("Play Circle", "ucla-wordpress-plugin"),
        value: "play-circle",
        icon: playCircle
      },
      {
        label: __("Sort", "ucla-wordpress-plugin"),
        value: "sort",
        icon: sort
      },
      {
        label: __("Sunny", "ucla-wordpress-plugin"),
        value: "sunny",
        icon: sunny
      },
      {
        label: __("Cloudy", "ucla-wordpress-plugin"),
        value: "cloudy",
        icon: cloudy
      },
      {
        label: __("Partly Cloudy", "ucla-wordpress-plugin"),
        value: "partly-cloudy",
        icon: partlyCloudy
      },
      {
        label: __("Fog", "ucla-wordpress-plugin"),
        value: "fog",
        icon: fog
      },
      {
        label: __("Windy", "ucla-wordpress-plugin"),
        value: "windy",
        icon: windy
      },
      {
        label: __("Rain", "ucla-wordpress-plugin"),
        value: "rain",
        icon: rain
      },
      {
        label: __("Thunderstorm", "ucla-wordpress-plugin"),
        value: "thunderstorm",
        icon: thunderstorm
      },
      {
        label: __("Moon", "ucla-wordpress-plugin"),
        value: "moon",
        icon: moon
      },
      {
        label: __("Full Moon", "ucla-wordpress-plugin"),
        value: "full-moon",
        icon: fullMoon
      },
      {
        label: __("Calendar", "ucla-wordpress-plugin"),
        value: "calendar",
        icon: calendar
      },
      {
        label: __("Clock", "ucla-wordpress-plugin"),
        value: "clock",
        icon: clock
      },
      {
        label: __("Error", "ucla-wordpress-plugin"),
        value: "error",
        icon: error
      },
      {
        label: __("Information", "ucla-wordpress-plugin"),
        value: "information",
        icon: information
      },
      {
        label: __("Success", "ucla-wordpress-plugin"),
        value: "success",
        icon: success
      },
      {
        label: __("Warning", "ucla-wordpress-plugin"),
        value: "warning",
        icon: warning
      },
    ];

    // console.log("withSidebarSelect", props);
    return (
      <>
        <BlockEdit {...props} />
        <InspectorControls>
          <PanelBody className="button-icon-picker" title={__("Button Settings")}>
            <Text style={{marginBottom: "8px"}} color="rgb(30, 30, 30)" isBlock={true} size="11px" upperCase={true} weight={500}>Button Icon</Text>
            <PanelRow>
              <Grid
                className="button-icon-picker__grid"
                columns="5"
                gap="0"
              >
                {iconSelectOption.map((icon, index) => (
                  <Button
                    key={index}
                    label={icon?.label}
                    isPressed={buttonIcon === icon.value}
                    className="button-icon-picker__button"
                    onClick={() => {
                      setAttributes({
                        buttonIcon: buttonIcon === icon.value ? null : icon.value,
                      });
                    }}
                  >
                    {icon.icon ?? icon.label}
                  </Button>
                ))}
              </Grid>
            </PanelRow>
            {buttonIcon && (
              <SelectControl
                __next40pxDefaultSize
                __nextHasNoMarginBottom
                value={buttonIconAlign}
                label={__("Align Icon")}
                options={[
                  {
                    label: __("Left", "ucla-wordpress-plugin"),
                    value: "lead",
                  },
                  {
                    label: __("Right", "ucla-wordpress-plugin"),
                    value: "trail",
                  },
                ]}
                onChange={(value) => {
                  setAttributes({
                    buttonIconAlign: value,
                  });
                }}
              />
            )}
          </PanelBody>
        </InspectorControls>
      </>
    );
  };
}, "withSidebarSelect");

wp.hooks.addFilter(
  "editor.BlockEdit",
  "ucla-wordpress-plugin/with-sidebar-select",
  withSidebarSelect
);

const withSidebarSelectProp = createHigherOrderComponent((BlockListBlock) => {
  return (props) => {
    // If current block is not allowed
    if (!enableSideBarOnBlocks.includes(props.name)) {
      return <BlockListBlock {...props} />;
    }

    // console.log("withSidebarSelectProp", props);
    const { attributes } = props;
    const { buttonIcon, buttonIconAlign } = attributes;
    if (buttonIcon) {
      return (
        <BlockListBlock
          {...props}
          className={`ucla-btn--icon ucla-icon--${buttonIcon} ucla-btn--icon-${buttonIconAlign}`}
        />
      );
    } else {
      return <BlockListBlock {...props} />;
    }
  };
}, "withSidebarSelectProp");

wp.hooks.addFilter(
  "editor.BlockListBlock",
  "ucla-wordpress-plugin/with-sidebar-select-prop",
  withSidebarSelectProp
);

const saveSidebarSelectAttribute = (extraProps, blockType, attributes) => {
  // Do nothing if it's another block than our defined ones.
  if (enableSideBarOnBlocks.includes(blockType.name)) {
    const { buttonIcon, buttonIconAlign } = attributes;
    if (buttonIcon) {
      extraProps.className = classnames(
        extraProps.className,
        `ucla-btn--icon ucla-icon--${buttonIcon} ucla-btn--icon-${buttonIconAlign}`
      );
    }
  }

  return extraProps;
};
wp.hooks.addFilter(
  "blocks.getSaveContent.extraProps",
  "ucla-wordpress-plugin/save-sidebar-select-attribute",
  saveSidebarSelectAttribute
);
