/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/developers/block-api/#registering-a-block
 */
import { registerBlockType } from "@wordpress/blocks";

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor. All other files
 * get applied to the editor only.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */
// import "./editor.scss";

/**
 * Internal dependencies
 */
import Edit from "./edit";
import Save from "./save";
import metadata from "./block.json";

registerBlockType(metadata.name, {
  icon: {
    src: (
      <svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        aria-hidden="true"
        focusable="false"
      >
        <rect x="2" y="2" width="1.5" height="20" fill="#333333"></rect>
        <rect x="21" y="2" width="1.5" height="20" fill="#333333"></rect>
        <rect
          x="2"
          y="3"
          width="1.5"
          height="20.5"
          transform="rotate(-90 2 3)"
          fill="#333333"
        ></rect>
        <rect
          x="2"
          y="22"
          width="1.5"
          height="20.5"
          transform="rotate(-90 2 22)"
          fill="#333333"
        ></rect>
        <rect
          x="2"
          y="15"
          width="1.5"
          height="20.5"
          transform="rotate(-90 2 15)"
          fill="#333333"
        ></rect>
        <rect
          x="2"
          y="9"
          width="1.5"
          height="20.5"
          transform="rotate(-90 2 9)"
          fill="#333333"
        ></rect>
      </svg>
    ),
  },
  edit: Edit,
  save: Save,
});
