import { __ } from "@wordpress/i18n";
import {
  InspectorControls,
  RichText,
  InnerBlocks,
  useBlockProps,
} from "@wordpress/block-editor";

// TODO: Set panel for default opens

import { PanelBody, ToggleControl } from "@wordpress/components";
import { useSelect } from "@wordpress/data";
const ALLOWED_BLOCKS = ["ucla-wordpress-plugin/accordion-item"];
const TEMPLATE = [
  ["ucla-wordpress-plugin/accordion-item", {}],
  ["ucla-wordpress-plugin/accordion-item", {}],
];
const Edit = ({ attributes, setAttributes, clientId }) => {
  let { isMultiOpen } = attributes;
  const { blockCount } = useSelect((select) => ({
    blockCount: select("core/block-editor").getBlockCount(clientId),
  }));
  const blockProps = useBlockProps({
    className: `accordion${isMultiOpen ? "  is-multiselect" : ""}`,
  });
  // console.log(blockCount);
  return (
    <>
      <InspectorControls>
        <PanelBody>
          <ToggleControl
            label="Multi-Open Accordion"
            help={
              isMultiOpen
                ? "Can open multiple accordions at once"
                : "One accordion can be open at a time"
            }
            checked={isMultiOpen}
            onChange={(value) => {
              setAttributes({ isMultiOpen: value });
            }}
          />
        </PanelBody>
      </InspectorControls>
      <div {...blockProps}>
        <InnerBlocks allowedBlocks={ALLOWED_BLOCKS} template={TEMPLATE} />
      </div>
    </>
  );
};

export default Edit;
