import { InnerBlocks } from "@wordpress/block-editor";
import './style.scss';
const Save = ({ attributes: { accordionHeading, accordionHeadingLevel } }) => {
  const TagName = "h" + accordionHeadingLevel;
  return (
    <div className="accordion-item">
      <TagName className="accordion__heading">
        <button
          type="button"
          className="accordion__heading-button"
          aria-expanded="false"
        >
          {accordionHeading}
          <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
          >
            <path
              d="M18 9.41L16.59 8L12 12.58L7.41 8L6 9.41L12 15.41L18 9.41Z"
              fill="#333333"
            ></path>
          </svg>
        </button>
      </TagName>
      <div className="accordion__body">
        <div
          className="accordion__content"
        >
          <InnerBlocks.Content />
        </div>
      </div>
    </div>
  );
};

export default Save;
