import { __ } from "@wordpress/i18n";
import { useState } from "@wordpress/element";
import {
  RichText,
  InnerBlocks,
  useBlockProps,
  BlockControls,
  HeadingLevelDropdown
} from "@wordpress/block-editor";
import "./editor.scss";
const Edit = ({ attributes, setAttributes, clientId }) => {
  let { accordionHeading, accordionHeadingLevel } = attributes;
  let [isOpen, setIsOpen] = useState(true);
  const blockProps = useBlockProps({ className: "accordion-item" });
  const toggleAccordion = () => {
    setIsOpen(!isOpen);
  };
  const tagName = "h" + accordionHeadingLevel;
  return (
    <>
      <div {...blockProps}>
        <div className="accordion__heading">
          <span className="accordion__heading-button">
            <BlockControls group="block">
              <HeadingLevelDropdown
                value={accordionHeadingLevel}
                onChange={(newLevel) =>
                  setAttributes({ accordionHeadingLevel: newLevel })
                }
              />
            </BlockControls>
            <RichText
              value={accordionHeading ? accordionHeading : ""}
              tagName={tagName}
              allowedFormats={[]}
              onChange={(value) => setAttributes({ accordionHeading: value })}
              placeholder={__("Accordion Heading", "ucla-wordpress-plugin")}
            />
            <svg
              width="24"
              height="24"
              viewBox="0 0 24 24"
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
              onClick={toggleAccordion}
              style={isOpen ? { transform: "rotate(180deg)" } : {}}
            >
              <path
                d="M18 9.41L16.59 8L12 12.58L7.41 8L6 9.41L12 15.41L18 9.41Z"
                fill="#333333"
              ></path>
            </svg>
          </span>
        </div>
        <div className="accordion__body" hidden={!isOpen}>
          <div className="accordion__content">
            <InnerBlocks />
          </div>
        </div>
      </div>
    </>
  );
};

export default Edit;
